/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.schema;

import org.neo4j.internal.kernel.api.TokenNameLookup;

public class SchemaUtil {
    public static final TokenNameLookup idTokenNameLookup = new TokenNameLookup(){

        @Override
        public String labelGetName(int labelId) {
            return String.format("label[%d]", labelId);
        }

        @Override
        public String relationshipTypeGetName(int relationshipTypeId) {
            return String.format("relType[%d]", relationshipTypeId);
        }

        @Override
        public String propertyKeyGetName(int propertyKeyId) {
            return String.format("property[%d]", propertyKeyId);
        }
    };

    private SchemaUtil() {
    }

    public static String niceProperties(TokenNameLookup tokenNameLookup, int[] propertyIds) {
        return SchemaUtil.niceProperties(tokenNameLookup, propertyIds, "", false);
    }

    public static String niceProperties(TokenNameLookup tokenNameLookup, int[] propertyIds, String prefix, boolean useBrackets) {
        StringBuilder properties = new StringBuilder();
        if (useBrackets) {
            properties.append("(");
        }
        for (int i = 0; i < propertyIds.length; ++i) {
            if (i > 0) {
                properties.append(", ");
            }
            properties.append(prefix).append(tokenNameLookup.propertyKeyGetName(propertyIds[i]));
        }
        if (useBrackets) {
            properties.append(")");
        }
        return properties.toString();
    }

    public static String niceLabelAndProperties(TokenNameLookup tokenNameLookup, int labelId, int[] propertyIds) {
        String label = tokenNameLookup.labelGetName(labelId);
        String properties = SchemaUtil.niceProperties(tokenNameLookup, propertyIds);
        return String.format(":%s(%s)", label, properties);
    }

    public static String niceRelTypeAndProperties(TokenNameLookup tokenNameLookup, int relTypeId, int[] propertyIds) {
        String relationshipTypeGetName = tokenNameLookup.relationshipTypeGetName(relTypeId);
        String properties = SchemaUtil.niceProperties(tokenNameLookup, propertyIds);
        return String.format("-[:%s(%s)]-", relationshipTypeGetName, properties);
    }

    public static String withType(String type, String schemaDescription) {
        return String.format("Index( %s, %s )", type, schemaDescription);
    }
}

