/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Iterator;
import java.util.List;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;

public interface IndexReference {
    public boolean isUnique();

    public int label();

    public int[] properties();

    default public String userDescription(TokenNameLookup tokenNameLookup) {
        String type = this.isUnique() ? "UNIQUE" : "GENERAL";
        return String.format("Index( %s, %s )", type, SchemaUtil.niceProperties(tokenNameLookup, this.properties()));
    }

    public static Iterator<IndexReference> sortByType(Iterator<IndexReference> indexes) {
        List materialized = Iterators.asList(indexes);
        return Iterators.concat((Iterator[])new Iterator[]{Iterators.filter(i -> !i.isUnique(), materialized.iterator()), Iterators.filter(IndexReference::isUnique, materialized.iterator())});
    }
}

