/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyPredicate;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;

public abstract class NeighbourCursor
implements NodeCursor {
    private final NodeCursor neighbours;
    private final RelationshipGroupCursor group;
    private final RelationshipTraversalCursor relationships;

    public static Builder outgoing(CursorFactory cursors, int label) {
        return new Builder(cursors).outgoing(label);
    }

    public static Builder outgoing(CursorFactory cursors, int label, PropertyPredicate relationshipProperties) {
        return new Builder(cursors).outgoing(label, relationshipProperties);
    }

    public static Builder incoming(CursorFactory cursors, int label) {
        return new Builder(cursors).incoming(label);
    }

    public static Builder incoming(CursorFactory cursors, int label, PropertyPredicate relationshipProperties) {
        return new Builder(cursors).incoming(label, relationshipProperties);
    }

    public static Builder any(CursorFactory cursors, int label) {
        return new Builder(cursors).any(label);
    }

    public static Builder any(CursorFactory cursors, int label, PropertyPredicate relationshipProperties) {
        return new Builder(cursors).any(label, relationshipProperties);
    }

    public static NeighbourCursor outgoing(CursorFactory cursors) {
        return new AnyLabel(cursors, true, false);
    }

    public static NeighbourCursor outgoing(CursorFactory cursors, PropertyPredicate relationshipProperties) {
        Objects.requireNonNull(relationshipProperties, "Relationship PropertyPredicate");
        return new FilteringAnyLabel(cursors, true, false, relationshipProperties);
    }

    public static NeighbourCursor incoming(CursorFactory cursors) {
        return new AnyLabel(cursors, false, true);
    }

    public static NeighbourCursor incoming(CursorFactory cursors, PropertyPredicate relationshipProperties) {
        Objects.requireNonNull(relationshipProperties, "Relationship PropertyPredicate");
        return new FilteringAnyLabel(cursors, false, true, relationshipProperties);
    }

    public static NeighbourCursor any(CursorFactory cursors) {
        return new AnyLabel(cursors, true, true);
    }

    public static NeighbourCursor any(CursorFactory cursors, PropertyPredicate relationshipProperties) {
        Objects.requireNonNull(relationshipProperties, "Relationship PropertyPredicate");
        return new FilteringAnyLabel(cursors, true, true, relationshipProperties);
    }

    public NeighbourCursor(CursorFactory cursors) {
        this.neighbours = cursors.allocateNodeCursor();
        this.group = cursors.allocateRelationshipGroupCursor();
        this.relationships = cursors.allocateRelationshipTraversalCursor();
    }

    public final void of(NodeCursor node) {
        node.relationships(this.group);
        this.group.close();
        this.relationships.close();
    }

    @Override
    public final boolean next() {
        while (!this.relationships.next()) {
            if (this.next(this.group, this.relationships)) continue;
            return false;
        }
        do {
            this.relationships.neighbour(this.neighbours);
        } while (this.relationships.shouldRetry());
        return this.neighbours.next();
    }

    protected abstract boolean next(RelationshipGroupCursor var1, RelationshipTraversalCursor var2);

    @Override
    public final boolean shouldRetry() {
        return this.neighbours.shouldRetry();
    }

    @Override
    public final void close() {
        this.neighbours.close();
        this.group.close();
        this.relationships.close();
    }

    @Override
    public final long nodeReference() {
        return this.neighbours.nodeReference();
    }

    @Override
    public final LabelSet labels() {
        return this.neighbours.labels();
    }

    @Override
    public final boolean hasProperties() {
        return this.neighbours.hasProperties();
    }

    @Override
    public final void relationships(RelationshipGroupCursor cursor) {
        this.neighbours.relationships(cursor);
    }

    @Override
    public void outgoingRelationships(RelationshipGroupCursor groups, RelationshipTraversalCursor relationships) {
        this.neighbours.outgoingRelationships(groups, relationships);
    }

    @Override
    public void incomingRelationships(RelationshipGroupCursor groups, RelationshipTraversalCursor relationships) {
        this.neighbours.incomingRelationships(groups, relationships);
    }

    @Override
    public void allRelationships(RelationshipGroupCursor groups, RelationshipTraversalCursor relationships) {
        this.neighbours.allRelationships(groups, relationships);
    }

    @Override
    public final void properties(PropertyCursor cursor) {
        this.neighbours.properties(cursor);
    }

    @Override
    public final long relationshipGroupReference() {
        return this.neighbours.relationshipGroupReference();
    }

    @Override
    public final long propertiesReference() {
        return this.neighbours.propertiesReference();
    }

    private static final class FilteringExplicitLabels
    extends NeighbourCursor {
        private final PropertyCursor properties;

        FilteringExplicitLabels(CursorFactory cursors, Builder.Entry[] spec) {
            super(cursors);
            this.properties = cursors.allocatePropertyCursor();
        }

        @Override
        protected boolean next(RelationshipGroupCursor group, RelationshipTraversalCursor relationships) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static final class ExplicitLabels
    extends NeighbourCursor {
        ExplicitLabels(CursorFactory cursors, Builder.Entry[] spec) {
            super(cursors);
        }

        @Override
        protected boolean next(RelationshipGroupCursor group, RelationshipTraversalCursor relationships) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static final class FilteringAnyLabel
    extends NeighbourCursor {
        private final PropertyCursor properties;
        private final boolean outgoing;
        private final boolean incoming;
        private final PropertyPredicate predicate;

        FilteringAnyLabel(CursorFactory cursors, boolean outgoing, boolean incoming, PropertyPredicate predicate) {
            super(cursors);
            this.properties = cursors.allocatePropertyCursor();
            this.outgoing = outgoing;
            this.incoming = incoming;
            this.predicate = predicate;
        }

        @Override
        protected boolean next(RelationshipGroupCursor group, RelationshipTraversalCursor relationships) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static final class AnyLabel
    extends NeighbourCursor {
        private final boolean outgoing;
        private final boolean incoming;

        AnyLabel(CursorFactory cursors, boolean outgoing, boolean incoming) {
            super(cursors);
            this.outgoing = outgoing;
            this.incoming = incoming;
        }

        @Override
        protected boolean next(RelationshipGroupCursor group, RelationshipTraversalCursor relationships) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static final class Builder {
        private static final Entry[] OF_ENTRIES = new Entry[0];
        private static final PropertyPredicate NO_FILTER = new PropertyPredicate(){};
        private final Map<Integer, Entry> alternatives = new HashMap<Integer, Entry>();
        private boolean filterProperties;
        private final CursorFactory cursors;

        public NeighbourCursor build() {
            Object[] entries = this.alternatives.values().toArray(OF_ENTRIES);
            Arrays.sort(entries);
            if (this.filterProperties) {
                return new FilteringExplicitLabels(this.cursors, (Entry[])entries);
            }
            return new ExplicitLabels(this.cursors, (Entry[])entries);
        }

        public Builder outgoing(int label) {
            return this.outgoing(label, NO_FILTER);
        }

        public Builder outgoing(int label, PropertyPredicate relationshipProperties) {
            if (Objects.requireNonNull(relationshipProperties, "Relationship PropertyPredicate") != NO_FILTER) {
                this.filterProperties = true;
            }
            this.alternatives.compute(label, (key, entry) -> {
                if (entry == null) {
                    entry = new Entry((int)key);
                }
                entry.outgoing(relationshipProperties);
                return entry;
            });
            return this;
        }

        public Builder incoming(int label) {
            return this.incoming(label, NO_FILTER);
        }

        public Builder incoming(int label, PropertyPredicate relationshipProperties) {
            if (Objects.requireNonNull(relationshipProperties, "Relationship PropertyPredicate") != NO_FILTER) {
                this.filterProperties = true;
            }
            this.alternatives.compute(label, (key, entry) -> {
                if (entry == null) {
                    entry = new Entry((int)key);
                }
                entry.incoming(relationshipProperties);
                return entry;
            });
            return this;
        }

        public Builder any(int label) {
            return this.any(label, NO_FILTER);
        }

        public Builder any(int label, PropertyPredicate relationshipProperties) {
            if (Objects.requireNonNull(relationshipProperties, "Relationship PropertyPredicate") != NO_FILTER) {
                this.filterProperties = true;
            }
            this.alternatives.compute(label, (key, entry) -> {
                if (entry == null) {
                    entry = new Entry((int)key);
                }
                entry.any(relationshipProperties);
                return entry;
            });
            return this;
        }

        private Builder(CursorFactory cursors) {
            this.cursors = cursors;
        }

        private static final class Entry
        implements Comparable<Entry> {
            final int label;
            PropertyPredicate incoming;
            PropertyPredicate outgoing;
            PropertyPredicate any;

            Entry(int label) {
                this.label = label;
            }

            @Override
            public int compareTo(Entry that) {
                return this.label - that.label;
            }

            void outgoing(PropertyPredicate predicate) {
                if (this.any != null || this.outgoing != null) {
                    throw new IllegalStateException("Already specified");
                }
                if (this.incoming == predicate) {
                    this.any = predicate;
                    this.incoming = null;
                } else {
                    this.outgoing = predicate;
                }
            }

            void incoming(PropertyPredicate predicate) {
                if (this.any != null || this.incoming != null) {
                    throw new IllegalStateException("Already specified");
                }
                if (this.outgoing == predicate) {
                    this.any = predicate;
                    this.outgoing = null;
                } else {
                    this.incoming = predicate;
                }
            }

            void any(PropertyPredicate predicate) {
                if (this.any != null || this.outgoing != null || this.incoming != null) {
                    throw new IllegalStateException("Already specified");
                }
                this.any = predicate;
            }
        }
    }
}

