/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.OpenTransactionMetadata;

public class ChunkedTransactionRegistry {
    private final NavigableMap<Long, ChunkEntry> chunkEntries = new ConcurrentSkipListMap<Long, ChunkEntry>();

    public void registerTransaction(long transactionId, long appendIndex, LogPosition logPositionBefore) {
        this.chunkEntries.put(transactionId, new ChunkEntry(appendIndex, logPositionBefore));
    }

    public void removeTransaction(long transactionId) {
        this.chunkEntries.remove(transactionId);
    }

    public OpenTransactionMetadata oldestOpenTransactionMetadata() {
        Map.Entry<Long, ChunkEntry> firstEntry = this.chunkEntries.firstEntry();
        if (firstEntry == null) {
            return null;
        }
        ChunkEntry chunkEntry = firstEntry.getValue();
        return new OpenTransactionMetadata(firstEntry.getKey(), chunkEntry.appendIndex(), chunkEntry.logPosition);
    }

    private record ChunkEntry(long appendIndex, LogPosition logPosition) {
    }
}

