/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.enrichment;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.BaseCommandReader;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.enrichment.Enrichment;
import org.neo4j.storageengine.api.enrichment.EnrichmentCommandFactory;

public class EnrichmentCommandReaderFactory
implements CommandReaderFactory {
    private final CommandReaderFactory commandReaderFactory;
    private final EnrichmentCommandFactory enrichmentCommandFactory;
    private final MemoryTracker memoryTracker;

    public EnrichmentCommandReaderFactory(CommandReaderFactory commandReaderFactory, EnrichmentCommandFactory enrichmentCommandFactory, MemoryTracker memoryTracker) {
        this.commandReaderFactory = commandReaderFactory;
        this.enrichmentCommandFactory = enrichmentCommandFactory;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public final CommandReader get(KernelVersion version) {
        CommandReader reader = this.commandReaderFactory.get(version);
        if (reader instanceof BaseCommandReader) {
            final BaseCommandReader baseReader = (BaseCommandReader)reader;
            return new BaseCommandReader(){

                @Override
                public StorageCommand read(byte commandType, ReadableChannel channel, MemoryTracker memory) throws IOException {
                    if (30 == commandType) {
                        KernelVersion kernelVersion = this.kernelVersion();
                        Enrichment.Read enrichment = Enrichment.Read.deserialize(kernelVersion, channel, EnrichmentCommandReaderFactory.this.memoryTracker);
                        return EnrichmentCommandReaderFactory.this.enrichmentCommandFactory.create(kernelVersion, enrichment);
                    }
                    return baseReader.read(commandType, channel, memory);
                }

                @Override
                public KernelVersion kernelVersion() {
                    return baseReader.kernelVersion();
                }
            };
        }
        return reader;
    }
}

