/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;

public class MetadataCache
implements KernelVersionRepository,
LogFormatVersionRepository {
    private volatile KernelVersion kernelVersion;
    private volatile LogFormat logFormat;

    public MetadataCache(LogTailMetadata logTailMetadata) {
        this(logTailMetadata.kernelVersion(), logTailMetadata.getCurrentLogFormat());
    }

    public MetadataCache(KernelVersion kernelVersion) {
        this(kernelVersion, LogFormat.fromKernelVersion(kernelVersion));
    }

    private MetadataCache(KernelVersion kernelVersion, LogFormat logFormat) {
        this.setKernelVersion(kernelVersion);
        this.setCurrentLogFormat(logFormat);
    }

    @Override
    public KernelVersion kernelVersion() {
        return this.kernelVersion;
    }

    @Override
    public void setKernelVersion(KernelVersion kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    @Override
    public void setCurrentLogFormat(LogFormat logFormat) {
        this.logFormat = logFormat;
    }

    @Override
    public LogFormat getCurrentLogFormat() {
        return this.logFormat;
    }
}

