/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.Value;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public class DefaultParameterValue {
    private final Object value;
    private final Neo4jTypes.AnyType type;

    public DefaultParameterValue(Object value, Neo4jTypes.AnyType type) {
        this.value = value;
        this.type = type;
    }

    public Object value() {
        return this.value;
    }

    public Object javaValue() {
        return this.unifyType(this.value);
    }

    public Neo4jTypes.AnyType neo4jType() {
        return this.type;
    }

    public static DefaultParameterValue ntString(String value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTString);
    }

    public static DefaultParameterValue ntInteger(long value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTInteger);
    }

    public static DefaultParameterValue ntFloat(double value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTFloat);
    }

    public static DefaultParameterValue ntBoolean(boolean value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTBoolean);
    }

    public static DefaultParameterValue ntMap(Map<String, Object> value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTMap);
    }

    public static DefaultParameterValue ntByteArray(byte[] value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTByteArray);
    }

    public static DefaultParameterValue ntList(List<?> value, Neo4jTypes.AnyType inner) {
        return new DefaultParameterValue(value, Neo4jTypes.NTList(inner));
    }

    public static DefaultParameterValue ntAny(Object value) {
        return new DefaultParameterValue(value, Neo4jTypes.NTAny);
    }

    public static DefaultParameterValue nullValue(Neo4jTypes.AnyType type) {
        return new DefaultParameterValue(null, type);
    }

    public DefaultParameterValue castAs(Neo4jTypes.AnyType type) {
        return new DefaultParameterValue(this.value, type);
    }

    public String toString() {
        return "DefaultParameterValue{value=" + String.valueOf(this.javaValue()) + ", type=" + String.valueOf(this.type) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultParameterValue that = (DefaultParameterValue)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (this.type.equals(Neo4jTypes.NTByteArray)) {
            return Arrays.deepEquals(new Object[]{this.value}, new Object[]{that.value});
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        return 31 * result + this.type.hashCode();
    }

    private Object unifyType(Object obj) {
        if (obj instanceof Value) {
            return ((Value)obj).map((ValueMapper)new ValueMapper.JavaMapper(this){

                public Object mapPath(VirtualPathValue value) {
                    throw new UnsupportedOperationException("Not allowed as default values ");
                }

                public Object mapNode(VirtualNodeValue value) {
                    throw new UnsupportedOperationException("Not allowed as default values ");
                }

                public Object mapRelationship(VirtualRelationshipValue value) {
                    throw new UnsupportedOperationException("Not allowed as default values ");
                }
            });
        }
        return obj;
    }
}

