/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.helpers.NameUtil;
import org.neo4j.internal.kernel.api.security.Segment;

public record ProcedureSegment(String procedure) implements Segment
{
    public static final ProcedureSegment ALL = new ProcedureSegment(null);

    @Override
    public boolean satisfies(Segment segment) {
        if (segment instanceof ProcedureSegment) {
            ProcedureSegment other = (ProcedureSegment)segment;
            return this.procedure == null || this.procedure.equals(other.procedure);
        }
        return false;
    }

    @Override
    public String toCypherSnippet() {
        if (this.procedure == null) {
            return "*";
        }
        return NameUtil.escapeGlob((String)this.procedure);
    }

    @Override
    public String toString() {
        return String.format("PROCEDURE(%s)", this.nullToStar(this.procedure));
    }
}

