/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.internal.helpers.NameUtil;
import org.neo4j.internal.kernel.api.security.PropertyRule;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public interface PatternSegment
extends Segment {
    public static final Set<String> ALL_ELEMENT_TYPES = Set.of();

    default public String elementTypeString() {
        return this.elementTypes().isEmpty() ? "" : this.elementTypes().stream().sorted().map(NameUtil::escapeName).collect(Collectors.joining("|", ":", ""));
    }

    default public String propertyString(String elementVariableName) {
        return String.format("%s.%s", elementVariableName, NameUtil.escapeName((String)this.property()));
    }

    default public String prettyPrintValue(Value value) {
        String method = null;
        String prettyPrintedValue = value.prettyPrint();
        Value value2 = value;
        Objects.requireNonNull(value2);
        Value value3 = value2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DateValue.class, LocalDateTimeValue.class, DateTimeValue.class, LocalTimeValue.class, TimeValue.class, DurationValue.class, PointValue.class}, (Object)value3, n)) {
            case 0: {
                DateValue ignored = (DateValue)value3;
                method = "date";
                break;
            }
            case 1: {
                LocalDateTimeValue ignored = (LocalDateTimeValue)value3;
                method = "localdatetime";
                break;
            }
            case 2: {
                DateTimeValue ignored = (DateTimeValue)value3;
                method = "datetime";
                break;
            }
            case 3: {
                LocalTimeValue ignored = (LocalTimeValue)value3;
                method = "localtime";
                break;
            }
            case 4: {
                TimeValue ignored = (TimeValue)value3;
                method = "time";
                break;
            }
            case 5: {
                DurationValue ignored = (DurationValue)value3;
                method = "duration";
                break;
            }
            case 6: {
                PointValue ignored = (PointValue)value3;
                prettyPrintedValue = value.toString();
                break;
            }
        }
        return method == null ? prettyPrintedValue : String.format("%s('%s')", method, prettyPrintedValue);
    }

    public PropertyRule buildPropertyRule(int var1);

    public Set<String> elementTypes();

    public String property();

    public String pattern();

    @Override
    default public boolean satisfies(Segment segment) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public String toCypherSnippet() {
        return String.format("FOR %s", this.pattern());
    }

    public static class RelNullPatternSegment
    extends NullPatternSegment {
        public RelNullPatternSegment(Set<String> elementTypes, String property, PropertyRule.NullOperator operator) {
            super(elementTypes, property, operator);
        }

        public RelNullPatternSegment(String property, PropertyRule.NullOperator operator) {
            this(ALL_ELEMENT_TYPES, property, operator);
        }

        @Override
        public String pattern() {
            return String.format("()-[r%s]-() WHERE %s", this.elementTypeString(), this.operator.toPredicateString(this.propertyString("r")));
        }
    }

    public static class NodeNullPatternSegment
    extends NullPatternSegment {
        public NodeNullPatternSegment(Set<String> elementTypes, String property, PropertyRule.NullOperator operator) {
            super(elementTypes, property, operator);
        }

        public NodeNullPatternSegment(String property, PropertyRule.NullOperator operator) {
            this(ALL_ELEMENT_TYPES, property, operator);
        }

        @Override
        public String pattern() {
            return String.format("(n%s) WHERE %s", this.elementTypeString(), this.operator.toPredicateString(this.propertyString("n")));
        }
    }

    public static abstract class NullPatternSegment
    implements PatternSegment {
        protected final Set<String> elementTypes;
        protected final String property;
        protected final PropertyRule.NullOperator operator;

        public NullPatternSegment(Set<String> elementTypes, String property, PropertyRule.NullOperator operator) {
            Preconditions.requireNonNull(elementTypes, (String)"elementTypes must not be null");
            Preconditions.requireNonNull((Object)property, (String)"property must not be null");
            this.elementTypes = elementTypes;
            this.property = property;
            this.operator = operator;
        }

        @Override
        public Set<String> elementTypes() {
            return this.elementTypes;
        }

        @Override
        public String property() {
            return this.property;
        }

        public PropertyRule.NullOperator operator() {
            return this.operator;
        }

        @Override
        public PropertyRule buildPropertyRule(int securityProperty) {
            return PropertyRule.newNullRule(securityProperty, this.operator());
        }

        public String toString() {
            return String.format("FOR(%s)", this.pattern());
        }
    }

    public static class RelValuePatternSegment
    extends ValuePatternSegment {
        public RelValuePatternSegment(Set<String> elementTypes, String property, Value value, PropertyRule.ComparisonOperator operator) {
            super(elementTypes, property, value, operator);
        }

        public RelValuePatternSegment(String property, Value value, PropertyRule.ComparisonOperator operator) {
            this(ALL_ELEMENT_TYPES, property, value, operator);
        }

        @Override
        public String pattern() {
            return String.format("()-[r%s]-() WHERE %s", this.elementTypeString(), this.operator.toPredicateString(this.propertyString("r"), this.prettyPrintValue(this.value)));
        }
    }

    public static class NodeValuePatternSegment
    extends ValuePatternSegment {
        public NodeValuePatternSegment(Set<String> elementTypes, String property, Value value, PropertyRule.ComparisonOperator operator) {
            super(elementTypes, property, value, operator);
        }

        public NodeValuePatternSegment(String property, Value value, PropertyRule.ComparisonOperator operator) {
            this(ALL_ELEMENT_TYPES, property, value, operator);
        }

        @Override
        public String pattern() {
            return String.format("(n%s) WHERE %s", this.elementTypeString(), this.operator.toPredicateString(this.propertyString("n"), this.prettyPrintValue(this.value)));
        }
    }

    public static abstract class ValuePatternSegment
    implements PatternSegment {
        protected final Set<String> elementTypes;
        protected final String property;
        protected final Value value;
        protected final PropertyRule.ComparisonOperator operator;

        public ValuePatternSegment(Set<String> elementTypes, String property, Value value, PropertyRule.ComparisonOperator operator) {
            Preconditions.requireNonNull(elementTypes, (String)"elementTypes must not be null");
            Preconditions.requireNonNull((Object)property, (String)"property must not be null");
            Preconditions.requireNonNull((Object)value, (String)"value must not be null");
            Preconditions.checkArgument((value != Values.NO_VALUE ? 1 : 0) != 0, (String)"value must not be NO_VALUE. Use NullPatternSegment for this purpose.");
            this.elementTypes = elementTypes;
            this.property = property;
            this.value = value;
            this.operator = operator;
        }

        @Override
        public Set<String> elementTypes() {
            return this.elementTypes;
        }

        @Override
        public String property() {
            return this.property;
        }

        public Value value() {
            return this.value;
        }

        public PropertyRule.ComparisonOperator operator() {
            return this.operator;
        }

        @Override
        public PropertyRule buildPropertyRule(int securityProperty) {
            return PropertyRule.newRule(securityProperty, this.value(), this.operator());
        }

        public String toString() {
            return String.format("FOR(%s)", this.pattern());
        }
    }
}

