/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class ProcedureException
extends KernelException {
    @Deprecated
    public ProcedureException(Status statusCode, Throwable cause, String message, Object ... parameters) {
        super(statusCode, cause, message, parameters);
    }

    protected ProcedureException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, Throwable cause, String message, Object ... parameters) {
        super(gqlStatusObject, statusCode, cause, message, parameters);
    }

    @Deprecated
    public ProcedureException(Status statusCode, String message, Object ... parameters) {
        super(statusCode, message, parameters);
    }

    protected ProcedureException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, String message, Object ... parameters) {
        super(gqlStatusObject, statusCode, message, parameters);
    }

    public static ProcedureException indexInFailedState(String indexName, String errorMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N62).withParam(GqlParams.StringParam.idx, indexName).build();
        return new ProcedureException(gql, (Status)Status.Schema.IndexCreationFailed, errorMessage, new Object[0]);
    }

    public static ProcedureException indexDidNotComeOnline(String procedureName, String indexDescription, long timeout, TimeUnit timeoutUnits) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N02).withParam(GqlParams.StringParam.proc, procedureName).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N01).withParam(GqlParams.StringParam.proc, procedureName).withParam(GqlParams.NumberParam.timeAmount, (Number)timeout).withParam(GqlParams.StringParam.timeUnit, timeoutUnits.toString().toLowerCase(Locale.ROOT)).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureTimedOut, "Index on '%s' did not come online within %s %s", new Object[]{indexDescription, timeout, timeoutUnits});
    }

    public static ProcedureException noSuchProcedure(QualifiedName name) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N08).withParam(GqlParams.StringParam.procFun, name.toString()).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureNotFound, "There is no procedure with the name `%s` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.", name);
    }

    public static ProcedureException noSuchProcedure(int id) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N08).withParam(GqlParams.StringParam.procFun, Integer.toString(id)).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureNotFound, "There is no procedure with the internal id `%d` registered for this database instance.", id);
    }

    public static ProcedureException noSuchFunction(int id) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N08).withParam(GqlParams.StringParam.procFun, Integer.toString(id)).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureNotFound, "There is no function with the internal id `%d` registered for this database instance.", id);
    }

    public static ProcedureException noSuchProcedureOrFunction(String name) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N08).withParam(GqlParams.StringParam.procFun, name).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, "There is no `%s` in the current procedure call context.", name);
    }

    public static ProcedureException noSuchConstituentGraph(String graphName, String ctxDatabaseName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42002).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N01).withParam(GqlParams.StringParam.graph, graphName).withParam(GqlParams.StringParam.db, ctxDatabaseName).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, "'%s' is not a constituent of composite database '%s'".formatted(graphName, ctxDatabaseName), new Object[0]);
    }

    public static ProcedureException faultyClassFieldAnnotationStatic(String procField, String procClass) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N01).withParam(GqlParams.StringParam.procField, procField).withParam(GqlParams.StringParam.procClass, procClass).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "The field `%s` in the class named `%s` is annotated as a @Context field,%nbut it is static. @Context fields must be public, non-final and non-static,%nbecause they are reset each time a procedure is invoked.", procField, procClass);
    }

    public static ProcedureException unableToAccessFieldInjection(String procClass, String procField) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N03).withParam(GqlParams.StringParam.procClass, procClass).withParam(GqlParams.StringParam.procField, procField).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to set up injection for `%s`, failed to access field `%s", procClass, procField);
    }

    public static ProcedureException unableToAccessField(String procClass, String procField) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N03).withParam(GqlParams.StringParam.procClass, procClass).withParam(GqlParams.StringParam.procField, procField).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.TypeError, "Field `%s` in record `%s` cannot be accessed. Please ensure the field is marked as `public`.", procField, procClass);
    }

    public static ProcedureException missingClassFieldAnnotation(String procClass, String procField) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N04).withParam(GqlParams.StringParam.procClass, procClass).withParam(GqlParams.StringParam.procField, procField).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Field `%s` on `%s` is not annotated as a @" + Context.class.getSimpleName() + " and is not static. If you want to store state along with your procedure, please use a static field.", procField, procClass);
    }

    public static ProcedureException faultyClassFieldAnnotation(String procClass, String procField) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N05).withParam(GqlParams.StringParam.procClass, procClass).withParam(GqlParams.StringParam.procField, procField).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Field `%s` on `%s` must be non-final and public.", procField, procClass);
    }

    public static ProcedureException missingArgumentAnnotation(int position, String procMethod) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N06).withParam(GqlParams.NumberParam.pos, (Number)position).withParam(GqlParams.StringParam.procMethod, procMethod).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Argument at position %d in method `%s` is missing an `@%s` annotation.%nPlease add the annotation, recompile the class and try again.", position, procMethod, Name.class.getSimpleName());
    }

    public static ProcedureException missingArgumentName(int position, String procMethod) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N06).withParam(GqlParams.NumberParam.pos, (Number)position).withParam(GqlParams.StringParam.procMethod, procMethod).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Argument at position %d in method `%s` is annotated with a name,%nbut the name is empty, please provide a non-empty name for the argument.", position, procMethod, Name.class.getSimpleName());
    }

    public static ProcedureException invalidOrderingOfDefaultArguments(int position, String parameterValue, String procMethod) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N07).withParam(GqlParams.StringParam.procFun, "procedure").build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Non-default argument at position %d with name %s in method %s follows default argument. Add a default value or rearrange arguments so that the non-default values comes first.", position, parameterValue, procMethod);
    }

    public static ProcedureException duplicatedAnnotatedMethods(String procClass, String className) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N08).withParam(GqlParams.StringParam.procClass, procClass).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' contains multiple methods annotated with '@%s'.", procClass, className);
    }

    public static ProcedureException missingAnnotatedMethods(String procClass) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N08).withParam(GqlParams.StringParam.procClass, procClass).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Class '%s' must contain methods annotated with both '@%s' as well as '@%s'.", procClass, UserAggregationResult.class.getSimpleName(), UserAggregationUpdate.class.getSimpleName());
    }

    public static ProcedureException methodMustBeVoid(String procClass, String procMethod, String returnType) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N09).withParam(GqlParams.StringParam.procClass, procClass).withParam(GqlParams.StringParam.procMethod, procMethod).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Update method '%s' in %s has type '%s' but must have return type 'void'.", procMethod, procClass, returnType);
    }

    public static ProcedureException aggregationUpdateMethodNotPublic(String procClass, String procMethod) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N09).withParam(GqlParams.StringParam.procClass, procClass).withParam(GqlParams.StringParam.procMethod, procMethod).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation update method '%s' in %s must be public.", procMethod, procClass);
    }

    public static ProcedureException aggregationMethodNotPublic(String procClass, String procMethod) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N10).withParam(GqlParams.StringParam.procClass, procClass).withParam(GqlParams.StringParam.procMethod, procMethod).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation method '%s' in %s must be public.", procMethod, procClass);
    }

    public static ProcedureException aggregationResultMethodNotPublic(String procClass, String procMethod) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N10).withParam(GqlParams.StringParam.procClass, procClass).withParam(GqlParams.StringParam.procMethod, procMethod).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation result method '%s' in %s must be public.", procMethod, procClass);
    }

    public static ProcedureException aggregationClassNotPublic(String procClass) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N11).withParam(GqlParams.StringParam.procClass, procClass).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Aggregation class '%s' must be public.", procClass);
    }

    public static ProcedureException unableToFindPublicConstructor(String procClass) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N11).withParam(GqlParams.StringParam.procClass, procClass).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to find a usable public no-argument constructor in the class `%s`. Please add a valid, public constructor, recompile the class and try again.", procClass);
    }

    public static ProcedureException classNotVoid(String proc) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N12).withParam(GqlParams.StringParam.proc, proc).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Procedures with zero output fields must be declared as VOID", new Object[0]);
    }

    public static ProcedureException procedureNameAlreadyInUse(String name) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N13).withParam(GqlParams.StringParam.procFun, name).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register procedure, because the name `%s` is already in use.", name);
    }

    public static ProcedureException functionNameAlreadyInUse(String name) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N13).withParam(GqlParams.StringParam.procFun, name).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register function, because the name `%s` is already in use.", name);
    }

    public static ProcedureException aggregationFunctionNameAlreadyInUse(String name) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N13).withParam(GqlParams.StringParam.procFun, name).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register aggregation function, because the name `%s` is already in use.", name);
    }

    public static ProcedureException aggregationFunctionNameAlreadyInUseAsFunction(String name) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N13).withParam(GqlParams.StringParam.procFun, name).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register aggregation function, because the name `%s` is already in use as a function.", name);
    }

    public static ProcedureException aggregationFunctionNameAlreadyInUseAsAggregationFunction(String name) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N13).withParam(GqlParams.StringParam.procFun, name).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register function, because the name `%s` is already in use as an aggregation function.", name);
    }

    public static ProcedureException duplicateFieldName(String proc, String fieldType, String field) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N14).withParam(GqlParams.StringParam.proc, proc).withParam(GqlParams.StringParam.procFieldType, fieldType).withParam(GqlParams.StringParam.procField, field).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Procedure `%s` cannot be registered, because it contains a duplicated " + fieldType + " field, '%s'. You need to rename or remove one of the duplicate fields.", proc, field);
    }

    public static ProcedureException invalidMapKeyType(String typeName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N15).withParam(GqlParams.StringParam.valueType, typeName).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Maps are required to have `String` keys - but this map has `%s` keys.", typeName);
    }

    public static ProcedureException invalidDefaultValueType(String defaultValue, String type) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N16).withParam(GqlParams.StringParam.valueType, type).withParam(GqlParams.StringParam.input, defaultValue).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Default value `%s` could not be parsed as a %s", defaultValue, type);
    }

    public static ProcedureException nonReloadableNamespaces(List<String> nonReloadableNamespaces, Status statusCode) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N23).withParam(GqlParams.ListParam.namespaceList, nonReloadableNamespaces).build()).build();
        return new ProcedureException(gql, statusCode, "The following namespaces are not reloadable: %s.".formatted(nonReloadableNamespaces), new Object[0]);
    }

    public static ProcedureException loadFailedProcedureRestricted(String proc) {
        ErrorGqlStatusObject gql = GqlHelper.get52N34((String)proc);
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, ProcedureException.restrictedOldMessage(proc), new Object[0]);
    }

    public static ProcedureException loadFailedFunctionRestricted(String func) {
        ErrorGqlStatusObject gql = GqlHelper.get53N34((String)func);
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, ProcedureException.restrictedOldMessage(func), new Object[0]);
    }

    private static String restrictedOldMessage(String name) {
        return name + " is unavailable because it is sandboxed and has dependencies outside of the sandbox. Sandboxing is controlled by the " + GraphDatabaseSettings.procedure_unrestricted.name() + " setting. Only unrestrict procedures you can trust with access to database internals.";
    }

    public static ProcedureException noSuchIndex(String indexName, String procedureName, Boolean formatIndex) {
        ErrorGqlStatusObject gql = GqlHelper.get22N69_52N02((String)indexName, (String)("db." + procedureName));
        if (formatIndex.booleanValue()) {
            indexName = "'" + (String)indexName + "'";
        }
        return new ProcedureException(gql, (Status)Status.Schema.IndexNotFound, "No such index %s", indexName);
    }

    public static ProcedureException surpressedRegisterFailed(List<Throwable> surpressedExceptions) {
        Throwable exception = surpressedExceptions.get(surpressedExceptions.size() - 1);
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N00).withParam(GqlParams.StringParam.msgTitle, exception.getClass().getName()).withParam(GqlParams.StringParam.msg, exception.getMessage()).build();
        for (int i = surpressedExceptions.size() - 2; i >= 0; --i) {
            exception = surpressedExceptions.get(i);
            gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N00).withParam(GqlParams.StringParam.msgTitle, exception.getClass().getName()).withParam(GqlParams.StringParam.msg, exception.getMessage()).withCause(gql).build();
        }
        gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(gql).build();
        ProcedureException exc = new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, "Failed to register procedures for the following reasons:", new Object[0]);
        for (Throwable surpressedException : surpressedExceptions) {
            exc.addSuppressed(surpressedException);
        }
        return exc;
    }

    public static ProcedureException compilationFailed(boolean isProcedure, String name, Throwable cause) {
        ErrorGqlStatusObject gql = isProcedure ? GqlHelper.get51N00_52N35((String)name, (String)cause.getMessage()) : GqlHelper.get51N00_53N35((String)name, (String)cause.getMessage());
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureRegistrationFailed, cause, "Failed to compile %s defined in `%s`: %s", isProcedure ? "procedure" : "function", name, cause.getMessage());
    }

    public static ProcedureException invocationFailed(String type, String name, Throwable cause) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)cause);
        String typeAndName = String.format("%s `%s`", type, name);
        ErrorGqlStatusObject gql = ProcedureException.getInvocationFailedGqlStatus(cause, rootCause, type, name);
        if (cause instanceof Status.HasStatus) {
            Status.HasStatus statusException = (Status.HasStatus)cause;
            return new ProcedureException(gql, statusException.status(), cause, cause.getMessage(), new Object[0]);
        }
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, cause, "Failed to invoke %s: %s", typeAndName, "Caused by: " + String.valueOf(rootCause != null ? rootCause : cause));
    }

    private static ErrorGqlStatusObject getInvocationFailedGqlStatus(Throwable cause, Throwable rootCause, String type, String name) {
        if (type.equals("procedure")) {
            if (cause instanceof ErrorGqlStatusObject) {
                ErrorGqlStatusObject errorGqlStatusObject = (ErrorGqlStatusObject)cause;
                return GqlHelper.get52N37((String)name, (ErrorGqlStatusObject)errorGqlStatusObject);
            }
            if (rootCause instanceof ErrorGqlStatusObject) {
                ErrorGqlStatusObject errorGqlStatusObject = (ErrorGqlStatusObject)rootCause;
                return GqlHelper.get52N37((String)name, (ErrorGqlStatusObject)errorGqlStatusObject);
            }
            return GqlHelper.get52N37((String)name, (ErrorGqlStatusObject)GqlHelper.get52U00((String)name, (Throwable)cause));
        }
        if (cause instanceof ErrorGqlStatusObject) {
            ErrorGqlStatusObject errorGqlStatusObject = (ErrorGqlStatusObject)cause;
            return GqlHelper.get53N37((String)name, (ErrorGqlStatusObject)errorGqlStatusObject);
        }
        if (rootCause instanceof ErrorGqlStatusObject) {
            ErrorGqlStatusObject errorGqlStatusObject = (ErrorGqlStatusObject)rootCause;
            return GqlHelper.get53N37((String)name, (ErrorGqlStatusObject)errorGqlStatusObject);
        }
        return GqlHelper.get53N37((String)name, (ErrorGqlStatusObject)GqlHelper.get53U00((String)name, (Throwable)cause));
    }

    public static <EX extends Throwable & ErrorGqlStatusObject> ProcedureException invocationFailedWithInnerError(EX error, String type, String name) {
        ErrorGqlStatusObject gql = type.equals("procedure") ? GqlHelper.get52N37((String)name, (ErrorGqlStatusObject)error) : GqlHelper.get53N37((String)name, (ErrorGqlStatusObject)error);
        return new ProcedureException(gql, ((Status.HasStatus)error).status(), error, error.getMessage(), error);
    }

    public static ProcedureException invalidReturnType(String methodName, String badReturnValue) {
        String msg = String.format("Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a %s.", badReturnValue);
        ErrorGqlStatusObject gql = GqlHelper.getGql51N00_51N18((String)methodName);
        return new ProcedureException(gql, (Status)Status.Procedure.TypeError, msg, new Object[0]);
    }

    public static ProcedureException invalidReturnTypeExtended(String methodName, Class<?> userClass) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N18).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.procMethod, methodName).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define, with public non-final fields defining the fields in the record.%nIf you''d like your procedure to return `%s`, you could define a record class like:%npublic class Output '{'%n    public %s out;%n'}'%n%nAnd then define your procedure as returning `Stream<Output>`.", userClass.getSimpleName(), userClass.getSimpleName());
    }

    public static ProcedureException databaseNotFound(String databaseName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N51((String)databaseName);
        return new ProcedureException(gql, (Status)Status.Database.DatabaseNotFound, "Unable to find database with name " + databaseName, new Object[0]);
    }

    public static ProcedureException unableToRetrieveStatusForDatabaseNotFound(String databaseName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N51((String)databaseName);
        return new ProcedureException(gql, (Status)Status.Database.DatabaseNotFound, String.format("Unable to retrieve the status for database with name %s because no database with this name exists!", databaseName), new Object[0]);
    }

    public static ProcedureException invalidNumberOfProcedureOrFunctionArguments(Number expectedNumberOfArgs, Number obtainedNumberOfArgs, String procedureFunction, String signature, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I13).withParam(GqlParams.NumberParam.count1, expectedNumberOfArgs).withParam(GqlParams.NumberParam.count2, obtainedNumberOfArgs).withParam(GqlParams.StringParam.procFun, procedureFunction).withParam(GqlParams.StringParam.sig, signature).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, legacyMessage, new Object[0]);
    }

    public static ProcedureException invalidCallSignature(String procedureFunction, String signature, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I51).withParam(GqlParams.StringParam.procFun, procedureFunction).withParam(GqlParams.StringParam.sig, signature).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, legacyMessage, new Object[0]);
    }

    public static ProcedureException cannotInjectField(String procField, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N20).withParam(GqlParams.StringParam.procField, procField).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, cause, "Unable to inject component to field `%s`, please ensure it is public and non-final: %s", procField, cause.getMessage());
    }

    public static ProcedureException unableToCheckLicense(String procedureName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N09).withParam(GqlParams.StringParam.proc, procedureName).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N60).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, "Unable to determine license acceptance status", new Object[0]);
    }

    public static ProcedureException jmxError(ObjectName name, Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N25).withParam(GqlParams.StringParam.param, name.getCanonicalName()).build();
        return new ProcedureException(gql, (Status)Status.General.UnknownError, e, "JMX error while accessing `%s`, please report this. Message was: %s", name, e.getMessage());
    }

    public static ProcedureException notWriter(String name) {
        return new ProcedureException(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N02).withParam(GqlParams.StringParam.proc, name).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N07).build()).build(), (Status)Status.Cluster.NotALeader, "No write operations are allowed directly on this database. Writes must pass through the writer.", new Object[0]);
    }

    public static ProcedureException mustInvokeProcedureOnSecondary(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N05).withParam(GqlParams.StringParam.db, dbName).build();
        return new ProcedureException(gql, (Status)Status.Database.Unknown, String.format("Can't invoke procedure on this server because it is not a read replica for database '%s'", dbName), new Object[0]);
    }

    public static ProcedureException checkConnectivityWrongNumberArguments(int count) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N06).withParam(GqlParams.NumberParam.count, (Number)count).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, "Unexpected number of parameters: should have 0-2 parameters, but was %d", count);
    }

    public static ProcedureException checkConnectivityinvalidPortArgument(String port, Set<ConnectorType> portSet, Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N07).withParam(GqlParams.StringParam.port, port).withParam(GqlParams.ListParam.portList, portSet.stream().toList()).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, e, "Unrecognised port name '%s'. Valid values are: %s", port, Arrays.toString(portSet.toArray()));
    }

    public static ProcedureException checkConnectivityInvalidServerId(String server, String rawServer, Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N08).withParam(GqlParams.StringParam.server, server).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, e, "Provided identifier '%s' is not a valid server name or id", rawServer);
    }

    public static ProcedureException quarantineChangeFailed(String procedureName, Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N02).withParam(GqlParams.StringParam.proc, procedureName).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N17).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, e, e.getMessage(), new Object[0]);
    }

    public static ProcedureException quarantineChangeFailedWithCustomMessage(String procedureName, Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N02).withParam(GqlParams.StringParam.proc, procedureName).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N17).build()).build();
        String message = "Setting/removing the quarantine marker failed. Please refer to the server's debug log for more information.";
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, e, message, new Object[0]);
    }

    public static ProcedureException generalProcedureException(String procedure, Throwable e) {
        ErrorGqlStatusObject gql = GqlHelper.getGql52N02_52N11((String)procedure);
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, e, e.getMessage(), new Object[0]);
    }

    public static ProcedureException generalProcedureExceptionNoCause(String procedure, Status status, Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N02).withParam(GqlParams.StringParam.proc, procedure).build();
        return new ProcedureException(gql, status, e, e.getMessage(), new Object[0]);
    }

    public static ProcedureException generalProcedureExceptionWithCustomMessage(String procedure, Throwable e) {
        ErrorGqlStatusObject gql = GqlHelper.getGql52N02_52N11((String)procedure);
        String message = "An unexpected error has occurred. Please refer to the server's debug log for more information.";
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, e, message, new Object[0]);
    }

    public static ProcedureException invalidProcedureArgument(String invalidArgumentValue, String invalidArgumentProcParamName, String invalidArgumentProcName, String invalidArgumentProcParamFmt, Status statusCode, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N36).withParam(GqlParams.StringParam.field, invalidArgumentValue).withParam(GqlParams.StringParam.procParam, invalidArgumentProcParamName).withParam(GqlParams.StringParam.proc, invalidArgumentProcName).withParam(GqlParams.StringParam.procParamFmt, invalidArgumentProcParamFmt).build()).build();
        return new ProcedureException(gql, statusCode, legacyMessage, new Object[0]);
    }

    public static ProcedureException graphPropertiesNotFound(String graphName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42002_42N00((String)graphName);
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, "Graph properties not found for graph '%s'".formatted(graphName), new Object[0]);
    }

    public static ProcedureException failedToReloadProcedures(Throwable cause, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N24).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, cause, legacyMessage, new Object[0]);
    }

    public static ProcedureException wrongParameter(String providedInvalidArgument, String argumentName, String procedureName, String expectedFormat, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N22).withParam(GqlParams.StringParam.field, providedInvalidArgument).withParam(GqlParams.StringParam.procParam, argumentName).withParam(GqlParams.StringParam.proc, procedureName).withParam(GqlParams.StringParam.procParamFmt, expectedFormat).build()).build();
        return new ProcedureException(gql, (Status)Status.Procedure.ProcedureCallFailed, legacyMessage, new Object[0]);
    }
}

