/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.vector;

import java.util.Objects;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.NumberArray;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Values;

public interface VectorCandidate {
    public float floatElement(int var1);

    public double doubleElement(int var1);

    public int dimensions();

    public static VectorCandidate maybeFrom(AnyValue candidate) {
        if (candidate == null || candidate == Values.NO_VALUE) {
            return null;
        }
        if (candidate instanceof FloatingPointArray) {
            FloatingPointArray floatingPointArray = (FloatingPointArray)candidate;
            return new FloatingPointArrayVectorCandidate(floatingPointArray);
        }
        if (candidate instanceof NumberArray) {
            NumberArray numberArray = (NumberArray)candidate;
            return new NumberArrayVectorCandidate(numberArray);
        }
        if (candidate instanceof SequenceValue) {
            SequenceValue sequenceValue = (SequenceValue)candidate;
            return new SequenceValueVectorCandidate(sequenceValue);
        }
        return null;
    }

    public static VectorCandidate from(AnyValue candidate) {
        VectorCandidate vectorCandidate = VectorCandidate.maybeFrom(candidate);
        if (vectorCandidate == null) {
            Objects.requireNonNull(candidate, "Value cannot be null");
            throw new IllegalArgumentException("Value is not a valid vector candidate. Provided: " + String.valueOf(candidate));
        }
        return vectorCandidate;
    }

    public record FloatingPointArrayVectorCandidate(FloatingPointArray array) implements VectorCandidate
    {
        @Override
        public float floatElement(int index) {
            return this.array.floatValue(index);
        }

        @Override
        public double doubleElement(int index) {
            return this.array.doubleValue(index);
        }

        @Override
        public int dimensions() {
            return this.array.intSize();
        }
    }

    public record NumberArrayVectorCandidate(NumberArray array) implements VectorCandidate
    {
        @Override
        public float floatElement(int index) {
            return this.array.value(index).floatValue();
        }

        @Override
        public double doubleElement(int index) {
            return this.array.value(index).doubleValue();
        }

        @Override
        public int dimensions() {
            return this.array.intSize();
        }
    }

    public record SequenceValueVectorCandidate(SequenceValue sequence) implements VectorCandidate
    {
        @Override
        public float floatElement(int index) {
            float f;
            AnyValue anyValue = this.sequence.value((long)index);
            if (anyValue instanceof NumberValue) {
                NumberValue number = (NumberValue)anyValue;
                f = number.floatValue();
            } else {
                f = Float.NaN;
            }
            return f;
        }

        @Override
        public double doubleElement(int index) {
            double d;
            AnyValue anyValue = this.sequence.value((long)index);
            if (anyValue instanceof NumberValue) {
                NumberValue number = (NumberValue)anyValue;
                d = number.doubleValue();
            } else {
                d = Double.NaN;
            }
            return d;
        }

        @Override
        public int dimensions() {
            return this.sequence.intSize();
        }
    }
}

