/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.stream.Stream;
import org.neo4j.memory.MemoryTracker;

public class ProcedureCallContext {
    public static final String[] EMPTY_OUTPUT_FIELDNAMES = new String[0];
    private final int id;
    private final String[] outputFieldNames;
    private final boolean calledFromCypher;
    private final String database;
    private final boolean isSystemDatabase;
    private final MemoryTracker memoryTracker;
    private final String runtimeUsed;
    public static final ProcedureCallContext EMPTY = new ProcedureCallContext(-1, EMPTY_OUTPUT_FIELDNAMES, false, "", false, "", null);

    public ProcedureCallContext(int id, boolean calledFromCypher, String database, boolean isSystemDatabase, String runtimeUsed, MemoryTracker memoryTracker) {
        this(id, EMPTY_OUTPUT_FIELDNAMES, calledFromCypher, database, isSystemDatabase, runtimeUsed, memoryTracker);
    }

    public ProcedureCallContext(int id, String[] outputFieldNames, boolean calledFromCypher, String database, boolean isSystemDatabase, String runtimeUsed, MemoryTracker memoryTracker) {
        this.id = id;
        this.outputFieldNames = outputFieldNames;
        this.calledFromCypher = calledFromCypher;
        this.database = database;
        this.isSystemDatabase = isSystemDatabase;
        this.runtimeUsed = runtimeUsed;
        this.memoryTracker = memoryTracker;
    }

    public Stream<String> outputFields() {
        return Stream.of(this.outputFieldNames);
    }

    public boolean isCalledFromCypher() {
        return this.calledFromCypher;
    }

    public String databaseName() {
        return this.database;
    }

    public boolean isSystemDatabase() {
        return this.isSystemDatabase;
    }

    public int id() {
        return this.id;
    }

    public String cypherRuntimeName() {
        return this.runtimeUsed;
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }
}

