/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;

public class IndexNotApplicableKernelException
extends KernelException {
    public IndexNotApplicableKernelException(String msg) {
        super((Status)Status.Schema.IndexNotApplicable, msg, new Object[0]);
    }

    private IndexNotApplicableKernelException(ErrorGqlStatusObject gqlStatusObject, String msg) {
        super(gqlStatusObject, (Status)Status.Schema.IndexNotApplicable, msg, new Object[0]);
    }

    public static IndexNotApplicableKernelException indexNotApplicable(Log log, String indexName, String msg) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N15).withParam(GqlParams.StringParam.idx, indexName).build();
        IndexNotApplicableKernelException e = new IndexNotApplicableKernelException(gql, msg);
        log.error(msg, (Throwable)((Object)e));
        return e;
    }

    public static IndexNotApplicableKernelException vectorIndexDimensionalityMismatch(String indexName, int indexDim, int vectorDim) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N65).withParam(GqlParams.StringParam.idx, indexName).withParam(GqlParams.NumberParam.dim1, (Number)indexDim).withParam(GqlParams.NumberParam.dim2, (Number)vectorDim).build();
        return new IndexNotApplicableKernelException(gql, "Index query vector has a dimensionality of %d, but indexed vectors have %d.".formatted(indexDim, vectorDim));
    }
}

