/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import java.util.Arrays;
import java.util.HashSet;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.PathEvaluator;

public abstract class Evaluators {
    private static final PathEvaluator<?> ALL = new PathEvaluator.Adapter(){

        @Override
        public Evaluation evaluate(Path path, BranchState state) {
            return Evaluation.INCLUDE_AND_CONTINUE;
        }
    };
    private static final PathEvaluator ALL_BUT_START_POSITION = Evaluators.fromDepth(1);

    public static <STATE> PathEvaluator<STATE> all() {
        return ALL;
    }

    public static PathEvaluator excludeStartPosition() {
        return ALL_BUT_START_POSITION;
    }

    public static <STATE> PathEvaluator<STATE> toDepth(final int depth) {
        return new PathEvaluator.Adapter<STATE>(){

            @Override
            public Evaluation evaluate(Path path, BranchState state) {
                int pathLength = path.length();
                return Evaluation.of(pathLength <= depth, pathLength < depth);
            }
        };
    }

    public static <STATE> PathEvaluator<STATE> fromDepth(final int depth) {
        return new PathEvaluator.Adapter<STATE>(){

            @Override
            public Evaluation evaluate(Path path, BranchState state) {
                return Evaluation.ofIncludes(path.length() >= depth);
            }
        };
    }

    public static <STATE> PathEvaluator<STATE> atDepth(final int depth) {
        return new PathEvaluator.Adapter<STATE>(){

            @Override
            public Evaluation evaluate(Path path, BranchState state) {
                return path.length() == depth ? Evaluation.INCLUDE_AND_PRUNE : Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
    }

    public static <STATE> PathEvaluator<STATE> includingDepths(final int minDepth, final int maxDepth) {
        return new PathEvaluator.Adapter<STATE>(){

            @Override
            public Evaluation evaluate(Path path, BranchState state) {
                int length = path.length();
                return Evaluation.of(length >= minDepth && length <= maxDepth, length < maxDepth);
            }
        };
    }

    public static <STATE> PathEvaluator<STATE> lastRelationshipTypeIs(final Evaluation evaluationIfMatch, final Evaluation evaluationIfNoMatch, final RelationshipType type, RelationshipType ... orAnyOfTheseTypes) {
        if (orAnyOfTheseTypes.length == 0) {
            return new PathEvaluator.Adapter<STATE>(){

                @Override
                public Evaluation evaluate(Path path, BranchState state) {
                    Relationship rel = path.lastRelationship();
                    return rel != null && rel.isType(type) ? evaluationIfMatch : evaluationIfNoMatch;
                }
            };
        }
        final HashSet<String> expectedTypes = new HashSet<String>();
        expectedTypes.add(type.name());
        for (RelationshipType otherType : orAnyOfTheseTypes) {
            expectedTypes.add(otherType.name());
        }
        return new PathEvaluator.Adapter<STATE>(){

            @Override
            public Evaluation evaluate(Path path, BranchState state) {
                Relationship lastRelationship = path.lastRelationship();
                if (lastRelationship == null) {
                    return evaluationIfNoMatch;
                }
                return expectedTypes.contains(lastRelationship.getType().name()) ? evaluationIfMatch : evaluationIfNoMatch;
            }
        };
    }

    public static <STATE> PathEvaluator<STATE> includeWhereLastRelationshipTypeIs(RelationshipType type, RelationshipType ... orAnyOfTheseTypes) {
        return Evaluators.lastRelationshipTypeIs(Evaluation.INCLUDE_AND_CONTINUE, Evaluation.EXCLUDE_AND_CONTINUE, type, orAnyOfTheseTypes);
    }

    public static <STATE> PathEvaluator<STATE> pruneWhereLastRelationshipTypeIs(RelationshipType type, RelationshipType ... orAnyOfTheseTypes) {
        return Evaluators.lastRelationshipTypeIs(Evaluation.INCLUDE_AND_PRUNE, Evaluation.EXCLUDE_AND_CONTINUE, type, orAnyOfTheseTypes);
    }

    public static <STATE> PathEvaluator<STATE> endNodeIs(final Evaluation evaluationIfMatch, final Evaluation evaluationIfNoMatch, Node ... possibleEndNodes) {
        if (possibleEndNodes.length == 1) {
            final Node target = possibleEndNodes[0];
            return new PathEvaluator.Adapter<STATE>(){

                @Override
                public Evaluation evaluate(Path path, BranchState state) {
                    return target.equals(path.endNode()) ? evaluationIfMatch : evaluationIfNoMatch;
                }
            };
        }
        final HashSet<Node> endNodes = new HashSet<Node>(Arrays.asList(possibleEndNodes));
        return new PathEvaluator.Adapter<STATE>(){

            @Override
            public Evaluation evaluate(Path path, BranchState state) {
                return endNodes.contains(path.endNode()) ? evaluationIfMatch : evaluationIfNoMatch;
            }
        };
    }

    public static <STATE> PathEvaluator<STATE> includeWhereEndNodeIs(Node ... nodes) {
        return Evaluators.endNodeIs(Evaluation.INCLUDE_AND_CONTINUE, Evaluation.EXCLUDE_AND_CONTINUE, nodes);
    }

    public static <STATE> PathEvaluator<STATE> pruneWhereEndNodeIs(Node ... nodes) {
        return Evaluators.endNodeIs(Evaluation.INCLUDE_AND_PRUNE, Evaluation.EXCLUDE_AND_CONTINUE, nodes);
    }

    public static <STATE> PathEvaluator<STATE> includeIfContainsAll(final Node ... nodes) {
        if (nodes.length == 1) {
            return new PathEvaluator.Adapter<STATE>(){

                @Override
                public Evaluation evaluate(Path path, BranchState state) {
                    for (Node node : path.reverseNodes()) {
                        if (!node.equals(nodes[0])) continue;
                        return Evaluation.INCLUDE_AND_CONTINUE;
                    }
                    return Evaluation.EXCLUDE_AND_CONTINUE;
                }
            };
        }
        final HashSet<Node> fullSet = new HashSet<Node>(Arrays.asList(nodes));
        return new PathEvaluator.Adapter<STATE>(){

            @Override
            public Evaluation evaluate(Path path, BranchState state) {
                HashSet set = new HashSet(fullSet);
                for (Node node : path.reverseNodes()) {
                    if (!set.remove(node) || !set.isEmpty()) continue;
                    return Evaluation.INCLUDE_AND_CONTINUE;
                }
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
    }

    public static <STATE> PathEvaluator<STATE> includeIfAcceptedByAny(final PathEvaluator ... evaluators) {
        return new PathEvaluator.Adapter<STATE>(){

            @Override
            public Evaluation evaluate(Path path, BranchState state) {
                for (PathEvaluator evaluator : evaluators) {
                    if (!evaluator.evaluate(path, state).includes()) continue;
                    return Evaluation.INCLUDE_AND_CONTINUE;
                }
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
    }

    public static <STATE> PathEvaluator<STATE> includeIfAcceptedByAny(final Evaluator ... evaluators) {
        return new PathEvaluator.Adapter<STATE>(){

            @Override
            public Evaluation evaluate(Path path, BranchState state) {
                for (Evaluator evaluator : evaluators) {
                    if (!evaluator.evaluate(path).includes()) continue;
                    return Evaluation.INCLUDE_AND_CONTINUE;
                }
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
    }

    public static <STATE> PathEvaluator<STATE> endNodeIsAtDepth(final int depth, Node ... possibleEndNodes) {
        if (possibleEndNodes.length == 1) {
            final Node target = possibleEndNodes[0];
            return new PathEvaluator.Adapter<STATE>(){

                @Override
                public Evaluation evaluate(Path path, BranchState state) {
                    if (path.length() == depth) {
                        return target.equals(path.endNode()) ? Evaluation.INCLUDE_AND_PRUNE : Evaluation.EXCLUDE_AND_PRUNE;
                    }
                    return Evaluation.EXCLUDE_AND_CONTINUE;
                }
            };
        }
        final HashSet<Node> endNodes = new HashSet<Node>(Arrays.asList(possibleEndNodes));
        return new PathEvaluator.Adapter<STATE>(){

            @Override
            public Evaluation evaluate(Path path, BranchState state) {
                if (path.length() == depth) {
                    return endNodes.contains(path.endNode()) ? Evaluation.INCLUDE_AND_PRUNE : Evaluation.EXCLUDE_AND_PRUNE;
                }
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
    }
}

