/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.spatial;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.annotations.api.PublicApi;

@PublicApi
public final class Coordinate {
    private final double[] coordinate;

    public Coordinate(double ... coordinate) {
        if (coordinate.length < 2) {
            throw new IllegalArgumentException("A coordinate must have at least two elements");
        }
        this.coordinate = coordinate;
    }

    public List<Double> getCoordinate() {
        return Arrays.stream(this.coordinate).boxed().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinate that = (Coordinate)o;
        return Arrays.equals(this.coordinate, that.coordinate);
    }

    public int hashCode() {
        return Arrays.hashCode(this.coordinate);
    }
}

