/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.helpers.MathUtil;

public interface ExecutionPlanDescription {
    public String getName();

    public List<ExecutionPlanDescription> getChildren();

    public Map<String, Object> getArguments();

    public Set<String> getIdentifiers();

    public boolean hasProfilerStatistics();

    public ProfilerStatistics getProfilerStatistics();

    public static interface ProfilerStatistics {
        public long getRows();

        public long getDbHits();

        default public long getPageCacheHits() {
            return 0L;
        }

        default public long getPageCacheMisses() {
            return 0L;
        }

        default public double getPageCacheHitRatio() {
            return MathUtil.portion((double[])new double[]{this.getPageCacheHits(), this.getPageCacheMisses()});
        }
    }
}

