/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl;

import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class ExtendedPath
implements Path {
    private final Path start;
    private final Relationship lastRelationship;
    private final Node endNode;

    public ExtendedPath(Path start, Relationship lastRelationship) {
        this.start = start;
        this.lastRelationship = lastRelationship;
        this.endNode = lastRelationship.getOtherNode(start.endNode());
    }

    @Override
    public Node startNode() {
        return this.start.startNode();
    }

    @Override
    public Node endNode() {
        return this.endNode;
    }

    @Override
    public Relationship lastRelationship() {
        return this.lastRelationship;
    }

    @Override
    public Iterable<Relationship> relationships() {
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return new PrefetchingIterator<Relationship>(){
                    final Iterator<Relationship> startRelationships;
                    boolean lastReturned;
                    {
                        this.startRelationships = ExtendedPath.this.start.relationships().iterator();
                    }

                    protected Relationship fetchNextOrNull() {
                        if (this.startRelationships.hasNext()) {
                            return this.startRelationships.next();
                        }
                        if (!this.lastReturned) {
                            this.lastReturned = true;
                            return ExtendedPath.this.lastRelationship;
                        }
                        return null;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<Relationship> reverseRelationships() {
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return new PrefetchingIterator<Relationship>(){
                    final Iterator<Relationship> startRelationships;
                    boolean endReturned;
                    {
                        this.startRelationships = ExtendedPath.this.start.reverseRelationships().iterator();
                    }

                    protected Relationship fetchNextOrNull() {
                        if (!this.endReturned) {
                            this.endReturned = true;
                            return ExtendedPath.this.lastRelationship;
                        }
                        return this.startRelationships.hasNext() ? this.startRelationships.next() : null;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<Node> nodes() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new PrefetchingIterator<Node>(){
                    final Iterator<Node> startNodes;
                    boolean lastReturned;
                    {
                        this.startNodes = ExtendedPath.this.start.nodes().iterator();
                    }

                    protected Node fetchNextOrNull() {
                        if (this.startNodes.hasNext()) {
                            return this.startNodes.next();
                        }
                        if (!this.lastReturned) {
                            this.lastReturned = true;
                            return ExtendedPath.this.endNode;
                        }
                        return null;
                    }
                };
            }
        };
    }

    @Override
    public Iterable<Node> reverseNodes() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new PrefetchingIterator<Node>(){
                    final Iterator<Node> startNodes;
                    boolean endReturned;
                    {
                        this.startNodes = ExtendedPath.this.start.reverseNodes().iterator();
                    }

                    protected Node fetchNextOrNull() {
                        if (!this.endReturned) {
                            this.endReturned = true;
                            return ExtendedPath.this.endNode;
                        }
                        return this.startNodes.hasNext() ? this.startNodes.next() : null;
                    }
                };
            }
        };
    }

    @Override
    public int length() {
        return this.start.length() + 1;
    }

    @Override
    public Iterator<PropertyContainer> iterator() {
        return new PrefetchingIterator<PropertyContainer>(){
            final Iterator<PropertyContainer> startEntities;
            int lastReturned;
            {
                this.startEntities = ExtendedPath.this.start.iterator();
                this.lastReturned = 2;
            }

            protected PropertyContainer fetchNextOrNull() {
                if (this.startEntities.hasNext()) {
                    return this.startEntities.next();
                }
                switch (this.lastReturned--) {
                    case 2: {
                        return ExtendedPath.this.endNode;
                    }
                    case 1: {
                        return ExtendedPath.this.lastRelationship;
                    }
                }
                return null;
            }
        };
    }

    public static Path extend(Path path, Relationship withRelationship) {
        return new ExtendedPath(path, withRelationship);
    }
}

