/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import org.neo4j.codegen.ByteCodeUtils;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.asm.Label;
import org.neo4j.codegen.asm.MethodVisitor;
import org.neo4j.codegen.bytecode.Block;

public class Try
implements Block {
    private final MethodVisitor methodVisitor;
    private final Label start;
    private final Label tryBody;
    private final Label failBody;
    private final Label after;
    private final Parameter exception;

    public Try(MethodVisitor methodVisitor, Label start, Label tryBody, Label failBody, Label after, Parameter exception) {
        this.methodVisitor = methodVisitor;
        this.start = start;
        this.tryBody = tryBody;
        this.failBody = failBody;
        this.after = after;
        this.exception = exception;
    }

    public Parameter exception() {
        return this.exception;
    }

    public Label after() {
        return this.after;
    }

    @Override
    public void endBlock() {
        this.methodVisitor.visitTryCatchBlock(this.start, this.tryBody, this.failBody, ByteCodeUtils.byteCodeName(this.exception.type()));
        this.methodVisitor.visitLabel(this.tryBody);
        this.methodVisitor.visitJumpInsn(167, this.after);
    }
}

