/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Iterator;
import java.util.function.Consumer;
import org.neo4j.codegen.ClassGenerator;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.InvalidState;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.LocalVariables;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.MethodWriter;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TryCatchCodeBlock;
import org.neo4j.codegen.TypeReference;

public class CodeBlock
implements AutoCloseable {
    final ClassGenerator clazz;
    protected MethodWriter writer;
    private final CodeBlock parent;
    private boolean done;
    private final boolean continuableBlock;
    protected LocalVariables localVariables = new LocalVariables();

    protected CodeBlock(CodeBlock parent) {
        this(parent, parent.continuableBlock);
    }

    private CodeBlock(CodeBlock parent, boolean continuableBlock) {
        this.clazz = parent.clazz;
        this.writer = parent.writer;
        parent.writer = InvalidState.IN_SUB_BLOCK;
        this.parent = parent;
        this.localVariables = LocalVariables.copy(parent.localVariables);
        this.continuableBlock = continuableBlock;
    }

    CodeBlock(ClassGenerator clazz, MethodWriter writer, Parameter ... parameters) {
        this.clazz = clazz;
        this.writer = writer;
        this.parent = null;
        this.continuableBlock = false;
        if (!writer.isStatic()) {
            this.localVariables.createNew(clazz.handle(), "this");
        }
        for (Parameter parameter : parameters) {
            this.localVariables.createNew(parameter.type(), parameter.name());
        }
    }

    public ClassGenerator classGenerator() {
        return this.clazz;
    }

    public CodeBlock parent() {
        return this.parent;
    }

    @Override
    public void close() {
        this.endBlock();
        if (this.parent != null) {
            this.parent.writer = this.writer;
        } else {
            this.writer.done();
        }
        this.writer = InvalidState.BLOCK_CLOSED;
    }

    protected void endBlock() {
        if (!this.done) {
            this.writer.endBlock();
            this.done = true;
        }
    }

    public void expression(Expression expression) {
        this.writer.expression(expression);
    }

    public LocalVariable local(String name) {
        return this.localVariables.get(name);
    }

    public LocalVariable declare(TypeReference type, String name) {
        LocalVariable local = this.localVariables.createNew(type, name);
        this.writer.declare(local);
        return local;
    }

    public void assign(LocalVariable local, Expression value) {
        this.writer.assignVariableInScope(local, value);
    }

    public void assign(Class<?> type, String name, Expression value) {
        this.assign(TypeReference.typeReference(type), name, value);
    }

    public void assign(TypeReference type, String name, Expression value) {
        LocalVariable variable = this.localVariables.createNew(type, name);
        this.writer.assign(variable, value);
    }

    public void put(Expression target, FieldReference field, Expression value) {
        this.writer.put(target, field, value);
    }

    public void putStatic(FieldReference field, Expression value) {
        this.writer.putStatic(field, value);
    }

    public Expression self() {
        return this.load("this");
    }

    public Expression load(String name) {
        return Expression.load(this.local(name));
    }

    public CodeBlock forEach(Parameter local, Expression iterable) {
        String iteratorName = local.name() + "Iter";
        this.assign(Iterator.class, iteratorName, Expression.invoke(iterable, MethodReference.methodReference(Iterable.class, Iterator.class, "iterator", new Class[0]), new Expression[0]));
        CodeBlock block = this.whileLoop(Expression.invoke(this.load(iteratorName), MethodReference.methodReference(Iterator.class, Boolean.TYPE, "hasNext", new Class[0]), new Expression[0]));
        block.assign(local.type(), local.name(), Expression.cast(local.type(), Expression.invoke(block.load(iteratorName), MethodReference.methodReference(Iterator.class, Object.class, "next", new Class[0]), new Expression[0])));
        return block;
    }

    public CodeBlock whileLoop(Expression test) {
        this.writer.beginWhile(test, null);
        return new CodeBlock(this, true);
    }

    public CodeBlock whileLoop(Expression test, String labelName) {
        this.writer.beginWhile(test, labelName);
        return new CodeBlock(this, true);
    }

    public CodeBlock ifStatement(Expression test) {
        this.writer.beginIf(test);
        return new CodeBlock(this);
    }

    public void ifElseStatement(Expression test, Consumer<CodeBlock> onTrue, Consumer<CodeBlock> onFalse) {
        this.writer.ifElseStatement(test, onTrue, onFalse, this);
    }

    public CodeBlock block() {
        this.writer.beginBlock();
        return new CodeBlock(this);
    }

    public TryCatchCodeBlock tryCatch(Consumer<CodeBlock> onError, Parameter exception) {
        this.writer.beginTry(exception);
        return new TryCatchCodeBlock(this, onError, exception);
    }

    public void returns() {
        this.writer.returns();
    }

    public void returns(Expression value) {
        this.writer.returns(value);
    }

    public void continueIfPossible() {
        if (this.continuableBlock) {
            this.writer.continues();
        }
    }

    public void breaks(String labelName) {
        this.writer.breaks(labelName);
    }

    public void comment(String comment) {
        this.writer.comment(comment);
    }

    public void throwException(Expression exception) {
        this.writer.throwException(exception);
    }

    public TypeReference owner() {
        return this.clazz.handle();
    }
}

