/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.lang.reflect.Method;
import org.neo4j.codegen.TypeReference;

public class MethodReference {
    private final TypeReference owner;
    private final String name;
    private final TypeReference returns;
    private final TypeReference[] parameters;
    private final int modifiers;

    public static MethodReference methodReference(Class<?> owner, Class<?> returns, String name, Class<?> ... parameters) {
        try {
            int modifiers = owner.getMethod(name, parameters).getModifiers();
            return MethodReference.methodReference(TypeReference.typeReference(owner), TypeReference.typeReference(returns), name, modifiers, TypeReference.typeReferences(parameters));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No method with name " + name, e);
        }
    }

    public static MethodReference methodReference(Class<?> owner, TypeReference returns, String name, Class<?> ... parameters) {
        try {
            int modifiers = owner.getMethod(name, parameters).getModifiers();
            return MethodReference.methodReference(owner, returns, name, modifiers, TypeReference.typeReferences(parameters));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No method with name " + name, e);
        }
    }

    private static MethodReference methodReference(Class<?> owner, TypeReference returns, String name, int modifiers, TypeReference ... parameters) {
        return MethodReference.methodReference(TypeReference.typeReference(owner), returns, name, modifiers, parameters);
    }

    public static MethodReference methodReference(TypeReference owner, TypeReference returns, String name, TypeReference ... parameters) {
        return new MethodReference(owner, name, returns, 1, parameters);
    }

    public static MethodReference methodReference(TypeReference owner, TypeReference returns, String name, int modifiers, TypeReference ... parameters) {
        return new MethodReference(owner, name, returns, modifiers, parameters);
    }

    public static MethodReference methodReference(Method method) {
        return MethodReference.methodReference(method.getDeclaringClass(), method.getReturnType(), method.getName(), method.getParameterTypes());
    }

    public static MethodReference constructorReference(Class<?> owner, Class<?> firstParameter, Class<?> ... parameters) {
        return MethodReference.constructorReference(TypeReference.typeReference(owner), TypeReference.typeReferences(firstParameter, parameters));
    }

    public static MethodReference constructorReference(Class<?> owner, TypeReference ... parameters) {
        return MethodReference.constructorReference(TypeReference.typeReference(owner), parameters);
    }

    public static MethodReference constructorReference(TypeReference owner, TypeReference ... parameters) {
        return new MethodReference(owner, "<init>", TypeReference.VOID, 1, parameters);
    }

    MethodReference(TypeReference owner, String name, TypeReference returns, int modifiers, TypeReference[] parameters) {
        this.owner = owner;
        this.name = name;
        this.returns = returns;
        this.modifiers = modifiers;
        this.parameters = parameters;
    }

    public String name() {
        return this.name;
    }

    public TypeReference owner() {
        return this.owner;
    }

    public TypeReference returns() {
        return this.returns;
    }

    public TypeReference[] parameters() {
        return this.parameters;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public int modifiers() {
        return this.modifiers;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("MethodReference[");
        this.writeTo(result);
        return result.append("]").toString();
    }

    void writeTo(StringBuilder result) {
        this.owner.writeTo(result);
        result.append("#").append(this.name).append("(...)");
    }
}

