/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Iterator;
import java.util.function.Consumer;
import org.neo4j.codegen.ClassGenerator;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.InvalidState;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.LocalVariables;
import org.neo4j.codegen.MethodEmitter;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;

public class CodeBlock
implements AutoCloseable {
    final ClassGenerator clazz;
    private MethodEmitter emitter;
    private final CodeBlock parent;
    private boolean done;
    private boolean continuableBlock;
    protected LocalVariables localVariables = new LocalVariables();

    CodeBlock(CodeBlock parent) {
        this(parent, parent.continuableBlock);
    }

    CodeBlock(CodeBlock parent, boolean continuableBlock) {
        this.clazz = parent.clazz;
        this.emitter = parent.emitter;
        parent.emitter = InvalidState.IN_SUB_BLOCK;
        this.parent = parent;
        this.localVariables = LocalVariables.copy(parent.localVariables);
        this.continuableBlock = continuableBlock;
    }

    CodeBlock(ClassGenerator clazz, MethodEmitter emitter, Parameter ... parameters) {
        this.clazz = clazz;
        this.emitter = emitter;
        this.parent = null;
        this.continuableBlock = false;
        this.localVariables.createNew(clazz.handle(), "this");
        for (Parameter parameter : parameters) {
            this.localVariables.createNew(parameter.type(), parameter.name());
        }
    }

    public ClassGenerator classGenerator() {
        return this.clazz;
    }

    public CodeBlock parent() {
        return this.parent;
    }

    @Override
    public void close() {
        this.endBlock();
        if (this.parent != null) {
            this.parent.emitter = this.emitter;
        } else {
            this.emitter.done();
        }
        this.emitter = InvalidState.BLOCK_CLOSED;
    }

    protected void endBlock() {
        if (!this.done) {
            this.emitter.endBlock();
            this.done = true;
        }
    }

    public void expression(Expression expression) {
        this.emitter.expression(expression);
    }

    LocalVariable local(String name) {
        return this.localVariables.get(name);
    }

    public LocalVariable declare(TypeReference type, String name) {
        LocalVariable local = this.localVariables.createNew(type, name);
        this.emitter.declare(local);
        return local;
    }

    public void assign(LocalVariable local, Expression value) {
        this.emitter.assignVariableInScope(local, value);
    }

    public void assign(Class<?> type, String name, Expression value) {
        this.assign(TypeReference.typeReference(type), name, value);
    }

    public void assign(TypeReference type, String name, Expression value) {
        LocalVariable variable = this.localVariables.createNew(type, name);
        this.emitter.assign(variable, value);
    }

    public void put(Expression target, FieldReference field, Expression value) {
        this.emitter.put(target, field, value);
    }

    public Expression self() {
        return this.load("this");
    }

    public Expression load(String name) {
        return Expression.load(this.local(name));
    }

    public CodeBlock forEach(Parameter local, Expression iterable) {
        String iteratorName = local.name() + "Iter";
        this.assign(Iterator.class, iteratorName, Expression.invoke(iterable, MethodReference.methodReference(Iterable.class, Iterator.class, "iterator", new Class[0]), new Expression[0]));
        CodeBlock block = this.whileLoop(Expression.invoke(this.load(iteratorName), MethodReference.methodReference(Iterator.class, Boolean.TYPE, "hasNext", new Class[0]), new Expression[0]));
        block.assign(local.type(), local.name(), Expression.cast(local.type(), Expression.invoke(block.load(iteratorName), MethodReference.methodReference(Iterator.class, Object.class, "next", new Class[0]), new Expression[0])));
        return block;
    }

    public CodeBlock whileLoop(Expression test) {
        this.emitter.beginWhile(test);
        return new CodeBlock(this, true);
    }

    public CodeBlock ifStatement(Expression test) {
        this.emitter.beginIf(test);
        return new CodeBlock(this);
    }

    public CodeBlock block() {
        this.emitter.beginBlock();
        return new CodeBlock(this);
    }

    public void tryCatch(Consumer<CodeBlock> body, Consumer<CodeBlock> onError, Parameter exception) {
        this.emitter.tryCatchBlock(body, onError, this.localVariables.createNew(exception.type(), exception.name()), this);
    }

    public void returns() {
        this.emitter.returns();
    }

    public void returns(Expression value) {
        this.emitter.returns(value);
    }

    public void continueIfPossible() {
        if (this.continuableBlock) {
            this.emitter.continues();
        }
    }

    public void throwException(Expression exception) {
        this.emitter.throwException(exception);
    }

    public TypeReference owner() {
        return this.clazz.handle();
    }
}

