/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

final class ClasspathHelper {
    private ClasspathHelper() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    static String javaClasspathString() {
        return System.getProperty("java.class.path");
    }

    static Set<String> javaClasspath() {
        String[] classpathElements = ClasspathHelper.javaClasspathString().split(File.pathSeparator);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String element : classpathElements) {
            result.add(ClasspathHelper.canonicalPath(element));
        }
        return result;
    }

    static String fullClasspathStringFor(ClassLoader classLoader) {
        Set<String> classpathElements = ClasspathHelper.fullClasspathFor(classLoader);
        return ClasspathHelper.formClasspathString(classpathElements);
    }

    static Set<String> fullClasspathFor(ClassLoader classLoader) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(ClasspathHelper.javaClasspath());
        for (ClassLoader loader = classLoader; loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                result.add(ClasspathHelper.canonicalPath(url));
            }
        }
        return result;
    }

    private static String canonicalPath(URL url) {
        return ClasspathHelper.canonicalPath(url.getPath());
    }

    private static String canonicalPath(String path) {
        try {
            File file = new File(path);
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get canonical path for: '" + path + "'", e);
        }
    }

    private static String formClasspathString(Set<String> classPathElements) {
        StringBuilder classpath = new StringBuilder();
        Iterator<String> classPathElementsIterator = classPathElements.iterator();
        while (classPathElementsIterator.hasNext()) {
            classpath.append(classPathElementsIterator.next());
            if (!classPathElementsIterator.hasNext()) continue;
            classpath.append(File.pathSeparator);
        }
        return classpath.toString();
    }
}

