/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.asm.util;

import org.neo4j.codegen.asm.AnnotationVisitor;
import org.neo4j.codegen.asm.Attribute;
import org.neo4j.codegen.asm.FieldVisitor;
import org.neo4j.codegen.asm.TypePath;
import org.neo4j.codegen.asm.util.CheckAnnotationAdapter;
import org.neo4j.codegen.asm.util.CheckClassAdapter;
import org.neo4j.codegen.asm.util.CheckMethodAdapter;

public class CheckFieldAdapter
extends FieldVisitor {
    private boolean end;

    public CheckFieldAdapter(FieldVisitor fv) {
        this(393216, fv);
        if (this.getClass() != CheckFieldAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckFieldAdapter(int api, FieldVisitor fv) {
        super(api, fv);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkEnd();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(desc, visible));
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.checkEnd();
        int sort = typeRef >>> 24;
        if (sort != 19) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(sort));
        }
        CheckClassAdapter.checkTypeRefAndPath(typeRef, typePath);
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, desc, visible));
    }

    public void visitAttribute(Attribute attr) {
        this.checkEnd();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attr);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        super.visitEnd();
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

