/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.codegen.ByteCodes;
import org.neo4j.codegen.ClassEmitter;
import org.neo4j.codegen.CodeGenerator;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.bytecode.ClassByteCodeWriter;
import org.neo4j.codegen.source.Configuration;

public class ByteCodeGenerator
extends CodeGenerator {
    private final Configuration configuration;
    private final Map<TypeReference, ClassByteCodeWriter> classes = new HashMap<TypeReference, ClassByteCodeWriter>();

    public ByteCodeGenerator(ClassLoader parentClassLoader, Configuration configuration) {
        super(parentClassLoader);
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClassEmitter generate(TypeReference type, TypeReference base, TypeReference[] interfaces) {
        ClassByteCodeWriter codeWriter = new ClassByteCodeWriter(type, base, interfaces);
        ByteCodeGenerator byteCodeGenerator = this;
        synchronized (byteCodeGenerator) {
            ClassByteCodeWriter old = this.classes.put(type, codeWriter);
            if (old != null) {
                this.classes.put(type, old);
                throw new IllegalStateException("Trying to generate class twice: " + type);
            }
        }
        return codeWriter;
    }

    @Override
    protected Iterable<? extends ByteCodes> compile(ClassLoader classpathLoader) throws CompilationFailureException {
        return this.classes.values().stream().map(ClassByteCodeWriter::toByteCodes)::iterator;
    }
}

