/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodEmitter;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.source.ClassSourceWriter;

class MethodSourceWriter
implements MethodEmitter,
ExpressionVisitor {
    private static final Runnable BOTTOM = () -> {
        throw new IllegalStateException("Popped too many levels!");
    };
    private static final Runnable LEVEL = () -> {};
    private static final String INDENTATION = "    ";
    private final StringBuilder target;
    private final ClassSourceWriter classSourceWriter;
    private final Deque<Runnable> level = new LinkedList<Runnable>();

    public MethodSourceWriter(StringBuilder target, ClassSourceWriter classSourceWriter) {
        this.target = target;
        this.classSourceWriter = classSourceWriter;
        this.level.push(BOTTOM);
        this.level.push(LEVEL);
    }

    private StringBuilder indent() {
        int level = this.level.size();
        while (level-- > 0) {
            this.target.append(INDENTATION);
        }
        return this.target;
    }

    private StringBuilder append(CharSequence text) {
        return this.target.append(text);
    }

    @Override
    public void done() {
        if (this.level.size() != 1) {
            throw new IllegalStateException("unbalanced blocks!");
        }
        this.classSourceWriter.append(this.target);
    }

    @Override
    public void expression(Expression expression) {
        this.indent();
        expression.accept(this);
        this.target.append(";\n");
    }

    @Override
    public void put(Expression target, FieldReference field, Expression value) {
        this.indent();
        target.accept(this);
        this.append(".");
        this.append(field.name());
        this.append(" = ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void returns() {
        this.indent().append("return;\n");
    }

    @Override
    public void returns(Expression value) {
        this.indent().append("return ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void declare(LocalVariable local) {
        this.indent().append(local.type().name()).append(' ').append(local.name()).append(";\n");
    }

    @Override
    public void assignVariableInScope(LocalVariable local, Expression value) {
        this.indent().append(local.name()).append(" = ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void assign(LocalVariable variable, Expression value) {
        this.indent().append(variable.type().name()).append(' ').append(variable.name()).append(" = ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void beginWhile(Expression ... tests) {
        this.indent().append("while( ");
        String sep = "";
        for (Expression test : tests) {
            this.append(sep);
            test.accept(this);
            sep = " && ";
        }
        this.append(" )\n");
        this.indent().append("{\n");
        this.level.push(LEVEL);
    }

    @Override
    public void beginIf(Expression ... tests) {
        this.indent().append("if ( ");
        String sep = "";
        for (Expression test : tests) {
            this.append(sep);
            test.accept(this);
            sep = " && ";
        }
        this.append(" )\n");
        this.indent().append("{\n");
        this.level.push(LEVEL);
    }

    @Override
    public void beginIfNot(Expression ... tests) {
        Expression[] nots = new Expression[tests.length];
        for (int i = 0; i < tests.length; ++i) {
            nots[i] = Expression.not(tests[i]);
        }
        this.beginIf(nots);
    }

    @Override
    public void beginIfNull(Expression ... tests) {
        Expression[] nulls = new Expression[tests.length];
        for (int i = 0; i < tests.length; ++i) {
            nulls[i] = Expression.equal(tests[i], Expression.constant(null), TypeReference.OBJECT);
        }
        this.beginIf(nulls);
    }

    @Override
    public void beginIfNonNull(Expression ... tests) {
        Expression[] notNulls = new Expression[tests.length];
        for (int i = 0; i < tests.length; ++i) {
            notNulls[i] = Expression.not(Expression.equal(tests[i], Expression.constant(null), TypeReference.OBJECT));
        }
        this.beginIf(notNulls);
    }

    @Override
    public <T> void tryCatchBlock(Consumer<T> body, Consumer<T> handler, LocalVariable exception, T block) {
        this.indent().append("try\n");
        this.indent().append("{\n");
        this.level.push(LEVEL);
        body.accept(block);
        this.level.pop();
        this.indent().append("}\n");
        this.indent().append("catch ( ").append(exception.type().name()).append(" ").append(exception.name()).append(" )\n");
        this.indent().append("{\n");
        this.level.push(LEVEL);
        handler.accept(block);
        this.level.pop();
        this.indent().append("}\n");
    }

    @Override
    public void throwException(Expression exception) {
        this.indent().append("throw ");
        exception.accept(this);
        this.append(";\n");
    }

    @Override
    public void endBlock() {
        Runnable action = this.level.pop();
        this.indent().append("}\n");
        action.run();
    }

    @Override
    public void invoke(Expression target, MethodReference method, Expression[] arguments) {
        target.accept(this);
        if (!method.isConstructor()) {
            this.append(".").append(method.name());
        }
        this.arglist(arguments);
    }

    @Override
    public void invoke(MethodReference method, Expression[] arguments) {
        this.append(method.owner().name()).append('.').append(method.name());
        this.arglist(arguments);
    }

    private void arglist(Expression[] arguments) {
        this.append("(");
        String sep = " ";
        for (Expression argument : arguments) {
            this.append(sep);
            argument.accept(this);
            sep = ", ";
        }
        if (sep.length() > 1) {
            this.append(" ");
        }
        this.append(")");
    }

    @Override
    public void load(LocalVariable variable) {
        this.append(variable.name());
    }

    @Override
    public void getField(Expression target, FieldReference field) {
        target.accept(this);
        this.append(".").append(field.name());
    }

    @Override
    public void constant(Object value) {
        if (value == null) {
            this.append("null");
        } else if (value instanceof String) {
            this.append("\"").append(StringEscapeUtils.escapeJava((String)((String)value))).append('\"');
        } else if (value instanceof Integer) {
            this.append(value.toString());
        } else if (value instanceof Long) {
            this.append(value.toString()).append('L');
        } else if (value instanceof Double) {
            this.append(value.toString());
        } else if (value instanceof Boolean) {
            this.append(value.toString());
        } else {
            throw new UnsupportedOperationException(value.getClass() + " constants");
        }
    }

    @Override
    public void getStatic(FieldReference field) {
        this.append(field.owner().name()).append(".").append(field.name());
    }

    @Override
    public void loadThis(String sourceName) {
        this.append(sourceName);
    }

    @Override
    public void newInstance(TypeReference type) {
        this.append("new ").append(type.name());
    }

    @Override
    public void not(Expression expression) {
        this.append("!( ");
        expression.accept(this);
        this.append(" )");
    }

    @Override
    public void ternary(Expression test, Expression onTrue, Expression onFalse) {
        this.append("((");
        test.accept(this);
        this.append(") ? (");
        onTrue.accept(this);
        this.append(") : (");
        onFalse.accept(this);
        this.append("))");
    }

    @Override
    public void ternaryOnNull(Expression test, Expression onTrue, Expression onFalse) {
        this.ternary(Expression.equal(test, Expression.constant(null), TypeReference.OBJECT), onTrue, onFalse);
    }

    @Override
    public void ternaryOnNonNull(Expression test, Expression onTrue, Expression onFalse) {
        this.ternary(Expression.not(Expression.equal(test, Expression.constant(null), TypeReference.OBJECT)), onTrue, onFalse);
    }

    @Override
    public void equal(Expression lhs, Expression rhs, TypeReference ignored) {
        this.binaryOperation(lhs, rhs, " == ");
    }

    @Override
    public void or(Expression lhs, Expression rhs) {
        this.binaryOperation(lhs, rhs, " || ");
    }

    @Override
    public void and(Expression lhs, Expression rhs) {
        this.binaryOperation(lhs, rhs, " && ");
    }

    @Override
    public void addInts(Expression lhs, Expression rhs) {
        this.add(lhs, rhs);
    }

    @Override
    public void addLongs(Expression lhs, Expression rhs) {
        this.add(lhs, rhs);
    }

    @Override
    public void addDoubles(Expression lhs, Expression rhs) {
        this.add(lhs, rhs);
    }

    private void add(Expression lhs, Expression rhs) {
        this.binaryOperation(lhs, rhs, " + ");
    }

    @Override
    public void gt(Expression lhs, Expression rhs, TypeReference ignored) {
        this.binaryOperation(lhs, rhs, " > ");
    }

    @Override
    public void gte(Expression lhs, Expression rhs, TypeReference ignored) {
        this.binaryOperation(lhs, rhs, " >= ");
    }

    @Override
    public void lt(Expression lhs, Expression rhs, TypeReference ignored) {
        this.binaryOperation(lhs, rhs, " < ");
    }

    @Override
    public void lte(Expression lhs, Expression rhs, TypeReference ignored) {
        this.binaryOperation(lhs, rhs, " <= ");
    }

    @Override
    public void subtractInts(Expression lhs, Expression rhs) {
        this.sub(lhs, rhs);
    }

    @Override
    public void subtractLongs(Expression lhs, Expression rhs) {
        this.sub(lhs, rhs);
    }

    @Override
    public void subtractDoubles(Expression lhs, Expression rhs) {
        this.sub(lhs, rhs);
    }

    private void sub(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" - ");
        rhs.accept(this);
    }

    @Override
    public void multiplyLongs(Expression lhs, Expression rhs) {
        this.mul(lhs, rhs);
    }

    @Override
    public void multiplyDoubles(Expression lhs, Expression rhs) {
        this.mul(lhs, rhs);
    }

    private void mul(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" * ");
        rhs.accept(this);
    }

    private void div(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" / ");
        rhs.accept(this);
    }

    @Override
    public void cast(TypeReference type, Expression expression) {
        this.append("(");
        this.append("(").append(type.name()).append(") ");
        expression.accept(this);
        this.append(")");
    }

    @Override
    public void newArray(TypeReference type, Expression ... constants) {
        this.append("new ").append(type.name()).append("[]{");
        String sep = "";
        for (Expression constant : constants) {
            this.append(sep);
            constant.accept(this);
            sep = ", ";
        }
        this.append("}");
    }

    @Override
    public void longToDouble(Expression expression) {
        this.cast(TypeReference.typeReference(Double.TYPE), expression);
    }

    @Override
    public void pop(Expression expression) {
        expression.accept(this);
    }

    private void binaryOperation(Expression lhs, Expression rhs, String operator) {
        lhs.accept(this);
        this.append(operator);
        rhs.accept(this);
    }
}

