/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.TypeReference;

class ExpressionToString
implements ExpressionVisitor {
    private final StringBuilder result;

    public ExpressionToString(StringBuilder result) {
        this.result = result;
    }

    @Override
    public void invoke(Expression target, MethodReference method, Expression[] arguments) {
        this.result.append("invoke{target=");
        target.accept(this);
        this.result.append(", method=");
        method.writeTo(this.result);
        this.result.append("}(");
        String sep = "";
        for (Expression argument : arguments) {
            this.result.append(sep);
            argument.accept(this);
            sep = ", ";
        }
        this.result.append(")");
    }

    @Override
    public void invoke(MethodReference method, Expression[] arguments) {
        this.result.append("invoke{method=");
        method.writeTo(this.result);
        this.result.append("}(");
        String sep = "";
        for (Expression argument : arguments) {
            this.result.append(sep);
            argument.accept(this);
            sep = ", ";
        }
        this.result.append(")");
    }

    @Override
    public void load(LocalVariable variable) {
        this.result.append("load{type=");
        if (variable.type() == null) {
            this.result.append("null");
        } else {
            variable.type().writeTo(this.result);
        }
        this.result.append(", name=").append(variable.name()).append("}");
    }

    @Override
    public void getField(Expression target, FieldReference field) {
        this.result.append("get{target=");
        target.accept(this);
        this.result.append(", field=").append(field.name()).append("}");
    }

    @Override
    public void constant(Object value) {
        this.result.append("constant(").append(value).append(")");
    }

    @Override
    public void getStatic(FieldReference field) {
        this.result.append("get{class=").append(field.owner());
        this.result.append(", field=").append(field.name()).append("}");
    }

    @Override
    public void loadThis(String sourceName) {
        this.result.append("load{").append(sourceName).append("}");
    }

    @Override
    public void newInstance(TypeReference type) {
        this.result.append("new{type=");
        type.writeTo(this.result);
        this.result.append("}");
    }

    @Override
    public void not(Expression expression) {
        this.result.append("not(");
        expression.accept(this);
        this.result.append(")");
    }

    @Override
    public void ternary(Expression test, Expression onTrue, Expression onFalse) {
        this.result.append("ternary{test=");
        test.accept(this);
        this.result.append(", onTrue=");
        onTrue.accept(this);
        this.result.append(", onFalse=");
        onFalse.accept(this);
        this.result.append("}");
    }

    @Override
    public void ternaryOnNull(Expression test, Expression onTrue, Expression onFalse) {
        this.ternary(Expression.equal(test, Expression.constant(null), TypeReference.OBJECT), onTrue, onFalse);
    }

    @Override
    public void ternaryOnNonNull(Expression test, Expression onTrue, Expression onFalse) {
        this.ternary(Expression.not(Expression.equal(test, Expression.constant(null), TypeReference.OBJECT)), onTrue, onFalse);
    }

    @Override
    public void equal(Expression lhs, Expression rhs, TypeReference ignored) {
        this.result.append("equal(");
        lhs.accept(this);
        this.result.append(", ");
        rhs.accept(this);
        this.result.append(")");
    }

    @Override
    public void or(Expression lhs, Expression rhs) {
        this.result.append("or(");
        lhs.accept(this);
        this.result.append(", ");
        rhs.accept(this);
        this.result.append(")");
    }

    @Override
    public void and(Expression lhs, Expression rhs) {
        this.result.append("and(");
        lhs.accept(this);
        this.result.append(", ");
        rhs.accept(this);
        this.result.append(")");
    }

    @Override
    public void addInts(Expression lhs, Expression rhs) {
        this.add(lhs, rhs);
    }

    @Override
    public void addLongs(Expression lhs, Expression rhs) {
        this.add(lhs, rhs);
    }

    @Override
    public void addDoubles(Expression lhs, Expression rhs) {
        this.add(lhs, rhs);
    }

    private void add(Expression lhs, Expression rhs) {
        this.result.append("add(");
        lhs.accept(this);
        this.result.append(" + ");
        rhs.accept(this);
        this.result.append(")");
    }

    @Override
    public void gt(Expression lhs, Expression rhs, TypeReference ignored) {
        this.result.append("gt(");
        lhs.accept(this);
        this.result.append(" > ");
        rhs.accept(this);
        this.result.append(")");
    }

    @Override
    public void gte(Expression lhs, Expression rhs, TypeReference ignored) {
        this.result.append("gt(");
        lhs.accept(this);
        this.result.append(" >= ");
        rhs.accept(this);
        this.result.append(")");
    }

    @Override
    public void lt(Expression lhs, Expression rhs, TypeReference ignored) {
        this.result.append("lt(");
        lhs.accept(this);
        this.result.append(" < ");
        rhs.accept(this);
        this.result.append(")");
    }

    @Override
    public void lte(Expression lhs, Expression rhs, TypeReference ignored) {
        this.result.append("gt(");
        lhs.accept(this);
        this.result.append(" <= ");
        rhs.accept(this);
        this.result.append(")");
    }

    @Override
    public void subtractInts(Expression lhs, Expression rhs) {
        this.sub(lhs, rhs);
    }

    @Override
    public void subtractLongs(Expression lhs, Expression rhs) {
        this.sub(lhs, rhs);
    }

    @Override
    public void subtractDoubles(Expression lhs, Expression rhs) {
        this.sub(lhs, rhs);
    }

    private void sub(Expression lhs, Expression rhs) {
        this.result.append("sub(");
        lhs.accept(this);
        this.result.append(" - ");
        rhs.accept(this);
        this.result.append(")");
    }

    @Override
    public void multiplyLongs(Expression lhs, Expression rhs) {
        this.mul(lhs, rhs);
    }

    @Override
    public void multiplyDoubles(Expression lhs, Expression rhs) {
        this.mul(lhs, rhs);
    }

    private void mul(Expression lhs, Expression rhs) {
        this.result.append("mul(");
        lhs.accept(this);
        this.result.append(" * ");
        rhs.accept(this);
        this.result.append(")");
    }

    private void div(Expression lhs, Expression rhs) {
        this.result.append("div(");
        lhs.accept(this);
        this.result.append(" / ");
        rhs.accept(this);
        this.result.append(")");
    }

    @Override
    public void cast(TypeReference type, Expression expression) {
        this.result.append("cast{type=");
        type.writeTo(this.result);
        this.result.append(", expression=");
        expression.accept(this);
        this.result.append("}");
    }

    @Override
    public void newArray(TypeReference type, Expression ... constants) {
        this.result.append("newArray{type=");
        type.writeTo(this.result);
        this.result.append(", constants=");
        String sep = "";
        for (Expression constant : constants) {
            this.result.append(sep);
            constant.accept(this);
            sep = ", ";
        }
        this.result.append("}");
    }

    @Override
    public void longToDouble(Expression expression) {
        this.result.append("(double)");
        expression.accept(this);
    }

    @Override
    public void pop(Expression expression) {
        this.result.append("pop(");
        expression.accept(this);
        this.result.append(")");
    }
}

