/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import org.neo4j.codegen.TypeReference;

public class MethodReference {
    private final TypeReference owner;
    private final String name;

    public static MethodReference methodReference(Class<?> owner, Class<?> returns, String name, Class<?> ... parameters) {
        return MethodReference.methodReference(TypeReference.typeReference(owner), TypeReference.typeReference(returns), name, TypeReference.typeReferences(parameters));
    }

    public static MethodReference methodReference(Class<?> owner, TypeReference returns, String name, Class<?> ... parameters) {
        return MethodReference.methodReference(owner, returns, name, TypeReference.typeReferences(parameters));
    }

    public static MethodReference methodReference(Class<?> owner, TypeReference returns, String name, TypeReference ... parameters) {
        return MethodReference.methodReference(TypeReference.typeReference(owner), returns, name, parameters);
    }

    public static MethodReference methodReference(TypeReference owner, TypeReference returns, String name, TypeReference ... parameters) {
        return new MethodReference(owner, name);
    }

    public static MethodReference constructorReference(Class<?> owner, Class<?> firstParameter, Class<?> ... parameters) {
        return MethodReference.constructorReference(TypeReference.typeReference(owner), TypeReference.typeReferences(firstParameter, parameters));
    }

    public static MethodReference constructorReference(Class<?> owner, TypeReference ... parameters) {
        return MethodReference.constructorReference(TypeReference.typeReference(owner), parameters);
    }

    public static MethodReference constructorReference(TypeReference owner, TypeReference ... parameters) {
        return new MethodReference(owner, "<init>");
    }

    MethodReference(TypeReference owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public TypeReference owner() {
        return this.owner;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("MethodReference[");
        this.writeTo(result);
        return result.append("]").toString();
    }

    void writeTo(StringBuilder result) {
        this.owner.writeTo(result);
        result.append("#").append(this.name).append("(...)");
    }
}

