/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.neo4j.logging.FormattedLogFormat;
import org.neo4j.logging.Level;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;

public class SecurityLogHelper {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final Log4jLogProvider logProvider;

    public SecurityLogHelper() {
        this.logProvider = new Log4jLogProvider(LogConfig.createBuilder((OutputStream)this.outContent, (Level)Level.INFO).withFormat(FormattedLogFormat.PLAIN).withCategory(false).build());
    }

    public SecurityLogHelper(FormattedLogFormat format) {
        this.logProvider = new Log4jLogProvider(LogConfig.createBuilder((OutputStream)this.outContent, (Level)Level.INFO).withFormat(format).withCategory(false).build());
    }

    public Log4jLogProvider getLogProvider() {
        return this.logProvider;
    }

    public void assertDoesNotContainsMessage(String message) {
        Assertions.assertThat((String)this.outContent.toString()).doesNotContain(new CharSequence[]{message});
    }

    public ContentValidator assertLog(FormattedLogFormat format) {
        String[] contentLines = this.outContent.toString().split(System.lineSeparator());
        return SecurityLogHelper.assertLog(format, contentLines);
    }

    public static ContentValidator assertLog(FormattedLogFormat format, String[] content) {
        switch (format) {
            case PLAIN: {
                return new LoggerContentValidator(content);
            }
            case JSON: {
                return new JsonContentValidator(content);
            }
        }
        throw new AssertionError();
    }

    public static LogLineContent line() {
        return new LogLineContent();
    }

    public static class LogLineContent {
        private String expectedLevel;
        private String expectedSource;
        private String expectedDatabase;
        private String expectedUser;
        private String expectedMessage;

        public LogLineContent level(Level level) {
            this.expectedLevel = level.toString();
            return this;
        }

        public LogLineContent source(String source) {
            this.expectedSource = source;
            return this;
        }

        public LogLineContent database(String database) {
            this.expectedDatabase = database;
            return this;
        }

        public LogLineContent user(String username) {
            this.expectedUser = username;
            return this;
        }

        public LogLineContent message(String message) {
            this.expectedMessage = message;
            return this;
        }

        public String toString() {
            return "LogLineContent{expectedLevel='" + this.expectedLevel + "', expectedSource='" + this.expectedSource + "', expectedDatabase='" + this.expectedDatabase + "', expectedUser='" + this.expectedUser + "', expectedMessage='" + this.expectedMessage + "'}";
        }
    }

    private static class LoggerContentValidator
    implements ContentValidator {
        private final String[] contentLines;
        private static final Pattern LOGGER_LINE_PARSER = Pattern.compile("^(?<time>\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]\\d{4}) (?<level>\\w{4,5})\\s{1,2}((?<source>embedded-session\\t|bolt-session[^>]*>|server-session(?:\\t[^\\t]*){3})\\t)?(\\[(?<user>[^\\s]+)]: )?(?<message>.+?)");

        private LoggerContentValidator(String[] contentLines) {
            this.contentLines = contentLines;
        }

        @Override
        public void containsOnly(LogLineContent ... logLines) {
            Assertions.assertThat((int)logLines.length).isEqualTo(this.contentLines.length);
            for (int i = 0; i < logLines.length; ++i) {
                this.assertLine(this.contentLines[i], logLines[i]);
            }
        }

        @Override
        public void containsOrdered(LogLineContent ... logLines) {
            Assertions.assertThat((int)this.contentLines.length).isGreaterThanOrEqualTo(logLines.length);
            int j = 0;
            for (LogLineContent expected : logLines) {
                boolean found = false;
                while (j < this.contentLines.length) {
                    if (this.equalLine(this.contentLines[j], expected)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                org.junit.jupiter.api.Assertions.assertTrue((boolean)found, (String)String.format("Did not find line:  %s %nin %n%s", expected, Arrays.toString(this.contentLines)));
            }
        }

        private boolean equalLine(String contentLine, LogLineContent expected) {
            Matcher matcher = LOGGER_LINE_PARSER.matcher(contentLine);
            return matcher.matches() && Objects.equals(expected.expectedLevel, matcher.group("level")) && (expected.expectedUser == null || Objects.equals(expected.expectedUser, matcher.group("user"))) && Objects.equals(expected.expectedMessage, matcher.group("message"));
        }

        private void assertLine(String contentLine, LogLineContent expected) {
            Matcher matcher = LOGGER_LINE_PARSER.matcher(contentLine);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)matcher.matches());
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedLevel, (Object)matcher.group("level"), (String)"'level' mismatch");
            if (expected.expectedUser != null) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedUser, (Object)matcher.group("user"), (String)"'user' mismatch");
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedMessage, (Object)matcher.group("message"), (String)"'message' mismatch");
        }
    }

    private static class JsonContentValidator
    implements ContentValidator {
        private final String[] contentLines;

        JsonContentValidator(String[] contentLines) {
            this.contentLines = contentLines;
        }

        @Override
        public void containsOnly(LogLineContent ... logLines) {
            try {
                Assertions.assertThat((int)this.contentLines.length).isEqualTo(logLines.length);
                for (int i = 0; i < logLines.length; ++i) {
                    LogLineContent expected = logLines[i];
                    ObjectMapper mapper = new ObjectMapper();
                    Map map = (Map)mapper.readValue(this.contentLines[i], (TypeReference)new TypeReference<Map<String, String>>(){});
                    this.assertLine(expected, map);
                }
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void containsOrdered(LogLineContent ... logLines) {
            try {
                Assertions.assertThat((int)this.contentLines.length).isGreaterThanOrEqualTo(logLines.length);
                int j = 0;
                for (LogLineContent expected : logLines) {
                    boolean found = false;
                    while (j < this.contentLines.length) {
                        ObjectMapper mapper = new ObjectMapper();
                        Map map = (Map)mapper.readValue(this.contentLines[j], (TypeReference)new TypeReference<Map<String, String>>(){});
                        if (this.equalLine(expected, map)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)found, (String)String.format("Did not find line:  %s %nin %n%s", expected, Arrays.toString(this.contentLines)));
                }
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean equalLine(LogLineContent expected, Map<String, String> map) {
            return Objects.equals("security", map.get("type")) && Objects.equals(expected.expectedLevel, map.get("level")) && Objects.equals(expected.expectedSource, map.get("source")) && Objects.equals(expected.expectedDatabase, map.get("database")) && Objects.equals(expected.expectedUser, map.get("username")) && Objects.equals(expected.expectedMessage, map.get("message"));
        }

        private void assertLine(LogLineContent expected, Map<String, String> map) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"security", (Object)map.get("type"), (String)"'type' mismatch");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedLevel, (Object)map.get("level"), (String)"'level' mismatch");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedSource, (Object)map.get("source"), (String)"'source' mismatch");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedDatabase, (Object)map.get("database"), (String)"'database' mismatch");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedUser, (Object)map.get("username"), (String)"'user' mismatch");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.expectedMessage, (Object)map.get("message"), (String)"'message' mismatch");
        }
    }

    public static interface ContentValidator {
        public void containsOnly(LogLineContent ... var1);

        public void containsOrdered(LogLineContent ... var1);
    }
}

