/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.text.StringEscapeUtils;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.AbstractLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class AssertableLogProvider
extends AbstractLogProvider<Log> {
    private final boolean debugEnabled;
    private final Queue<LogCall> logCalls = new LinkedBlockingQueue<LogCall>();

    public AssertableLogProvider() {
        this(false);
    }

    public AssertableLogProvider(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void print(PrintStream out) {
        for (LogCall call : this.logCalls) {
            out.println(call.toLogLikeString());
            if (call.throwable == null) continue;
            call.throwable.printStackTrace(out);
        }
    }

    Queue<LogCall> getLogCalls() {
        return this.logCalls;
    }

    protected Log buildLog(Class<?> loggingClass) {
        return new AssertableLog(loggingClass.getName());
    }

    protected Log buildLog(String context) {
        return new AssertableLog(context);
    }

    public void clear() {
        this.logCalls.clear();
    }

    public String serialize() {
        return AssertableLogProvider.serialize0(this.logCalls.iterator(), LogCall::toLogLikeString);
    }

    private static String serialize0(Iterator<LogCall> events, Function<LogCall, String> serializer) {
        StringBuilder sb = new StringBuilder();
        while (events.hasNext()) {
            sb.append(serializer.apply(events.next()));
            sb.append('\n');
        }
        return sb.toString();
    }

    protected class AssertableLog
    extends AbstractLog {
        private final Logger debugLogger;
        private final Logger infoLogger;
        private final Logger warnLogger;
        private final Logger errorLogger;

        AssertableLog(String context) {
            this.debugLogger = new LogCallRecorder(context, Level.DEBUG);
            this.infoLogger = new LogCallRecorder(context, Level.INFO);
            this.warnLogger = new LogCallRecorder(context, Level.WARN);
            this.errorLogger = new LogCallRecorder(context, Level.ERROR);
        }

        public boolean isDebugEnabled() {
            return AssertableLogProvider.this.debugEnabled;
        }

        @Nonnull
        public Logger debugLogger() {
            return this.debugLogger;
        }

        @Nonnull
        public Logger infoLogger() {
            return this.infoLogger;
        }

        @Nonnull
        public Logger warnLogger() {
            return this.warnLogger;
        }

        @Nonnull
        public Logger errorLogger() {
            return this.errorLogger;
        }

        public void bulk(@Nonnull Consumer<Log> consumer) {
            consumer.accept((Log)this);
        }
    }

    private class LogCallRecorder
    implements Logger {
        private final String context;
        private final Level level;

        LogCallRecorder(String context, Level level) {
            this.context = context;
            this.level = level;
        }

        public void log(@Nonnull String message) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, this.level, message, null, null));
        }

        public void log(@Nonnull String message, @Nonnull Throwable throwable) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, this.level, message, null, throwable));
        }

        public void log(@Nonnull String format, Object ... arguments) {
            AssertableLogProvider.this.logCalls.add(new LogCall(this.context, this.level, format, arguments, null));
        }

        public void bulk(@Nonnull Consumer<Logger> consumer) {
            consumer.accept(this);
        }
    }

    static final class LogCall {
        private final String context;
        private final Level level;
        private final String message;
        private final Object[] arguments;
        private final Throwable throwable;

        private LogCall(String context, Level level, String message, Object[] arguments, Throwable throwable) {
            this.level = level;
            this.context = context;
            this.message = message;
            this.arguments = arguments;
            this.throwable = throwable;
        }

        String getContext() {
            return this.context;
        }

        Level getLevel() {
            return this.level;
        }

        String getMessage() {
            return this.message;
        }

        Object[] getArguments() {
            return this.arguments;
        }

        Throwable getThrowable() {
            return this.throwable;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LogCall{");
            builder.append(this.context);
            builder.append(' ');
            builder.append((Object)this.level);
            builder.append(", message=");
            if (this.message != null) {
                builder.append('\'').append(StringEscapeUtils.escapeJava((String)this.message)).append('\'');
            } else {
                builder.append("null");
            }
            builder.append(", arguments=");
            if (this.arguments != null) {
                builder.append('[');
                boolean first = true;
                for (Object arg : this.arguments) {
                    if (!first) {
                        builder.append(',');
                    }
                    first = false;
                    builder.append(StringEscapeUtils.escapeJava((String)String.valueOf(arg)));
                }
                builder.append(']');
            } else {
                builder.append("null");
            }
            builder.append(", throwable=");
            if (this.throwable != null) {
                builder.append('\'').append(StringEscapeUtils.escapeJava((String)this.throwable.toString())).append('\'');
            } else {
                builder.append("null");
            }
            builder.append('}');
            return builder.toString();
        }

        String toLogLikeString() {
            Object msg;
            if (this.arguments != null) {
                try {
                    msg = String.format(this.message, this.arguments);
                }
                catch (IllegalFormatException e) {
                    msg = String.format("IllegalFormat{message: \"%s\", arguments: %s}", this.message, Arrays.toString(this.arguments));
                }
            } else {
                msg = this.message;
            }
            if (this.throwable != null) {
                msg = (String)msg + " cause " + this.throwable.toString();
            }
            return String.format("%s @ %s: %s", new Object[]{this.level, this.context, msg});
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

