/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.Collections;
import java.util.List;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;

public class StubRelationshipCursor
extends DefaultCloseListenable
implements RelationshipTraversalCursor {
    private final List<TestRelationshipChain> store;
    private int offset;
    private int chainId;
    private boolean isClosed;
    private long nodeReference;
    private RelationshipSelection selection;
    private long neighbourNodeReference;

    public StubRelationshipCursor(TestRelationshipChain chain) {
        this(Collections.singletonList(chain));
    }

    public StubRelationshipCursor(List<TestRelationshipChain> store) {
        this.store = store;
        this.chainId = 0;
        this.offset = -1;
        this.isClosed = true;
    }

    void initialize(long nodeReference, RelationshipSelection selection, long neighbourNodeReference) {
        this.nodeReference = nodeReference;
        this.selection = selection;
        this.neighbourNodeReference = neighbourNodeReference;
        this.offset = -1;
        this.isClosed = true;
        this.chainId = this.findChain(nodeReference);
    }

    private int findChain(long nodeReference) {
        for (int i = 0; i < this.store.size(); ++i) {
            if (this.store.get(i).originNodeId() != nodeReference) continue;
            return i;
        }
        throw new IllegalArgumentException("No chain for " + nodeReference + " found");
    }

    public long relationshipReference() {
        return this.store.get((int)this.chainId).get((int)this.offset).id;
    }

    public int type() {
        return this.store.get((int)this.chainId).get((int)this.offset).type;
    }

    public void source(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void target(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        throw new UnsupportedOperationException("not implemented");
    }

    public long sourceNodeReference() {
        return this.store.get((int)this.chainId).get((int)this.offset).source;
    }

    public long targetNodeReference() {
        return this.store.get((int)this.chainId).get((int)this.offset).target;
    }

    public Reference propertiesReference() {
        return LongReference.NULL_REFERENCE;
    }

    public void otherNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public long otherNodeReference() {
        TestRelationshipChain chain = this.store.get(this.chainId);
        TestRelationshipChain.Data relationship = chain.get(this.offset);
        return relationship.source == chain.originNodeId() ? relationship.target : relationship.source;
    }

    public long originNodeReference() {
        return this.store.get(this.chainId).originNodeId();
    }

    public boolean next() {
        while (this.chainId >= 0 && this.chainId < this.store.size() && this.store.get(this.chainId).isValidOffset(this.offset + 1)) {
            ++this.offset;
            TestRelationshipChain chain = this.store.get(this.chainId);
            if (!chain.isValidOffset(this.offset)) {
                return false;
            }
            TestRelationshipChain.Data data = chain.get(this.offset);
            if (!this.selection.test(data.type, data.relationshipDirection(this.nodeReference)) || this.neighbourNodeReference != -1L && this.neighbourNodeReference != this.otherNodeReference()) continue;
            return true;
        }
        return false;
    }

    public void closeInternal() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setTracer(KernelReadTracer tracer) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void removeTracer() {
        throw new UnsupportedOperationException("not implemented");
    }
}

