/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.memory.MemoryTracker;

public class StubCursorFactory
implements CursorFactory {
    private final boolean continueWithLastItem;
    private final Queue<NodeCursor> nodeCursors = new ArrayDeque<NodeCursor>();
    private final Queue<NodeCursor> fullNodeCursors = new ArrayDeque<NodeCursor>();
    private final Queue<RelationshipScanCursor> relationshipScanCursors = new ArrayDeque<RelationshipScanCursor>();
    private final Queue<RelationshipScanCursor> fullRelationshipScanCursors = new ArrayDeque<RelationshipScanCursor>();
    private final Queue<RelationshipTraversalCursor> relationshipTraversalCursors = new LinkedList<RelationshipTraversalCursor>();
    private final Queue<RelationshipTraversalCursor> fullRelationshipTraversalCursors = new LinkedList<RelationshipTraversalCursor>();
    private final Queue<PropertyCursor> propertyCursors = new ArrayDeque<PropertyCursor>();
    private final Queue<PropertyCursor> fullPropertyCursors = new ArrayDeque<PropertyCursor>();
    private final Queue<NodeValueIndexCursor> nodeValueIndexCursors = new ArrayDeque<NodeValueIndexCursor>();
    private final Queue<NodeValueIndexCursor> fullNodeValueIndexCursors = new ArrayDeque<NodeValueIndexCursor>();
    private final Queue<NodeLabelIndexCursor> nodeLabelIndexCursors = new ArrayDeque<NodeLabelIndexCursor>();
    private final Queue<NodeLabelIndexCursor> fullNodeLabelIndexCursors = new ArrayDeque<NodeLabelIndexCursor>();
    private final Queue<RelationshipIndexCursor> relationshipIndexCursors = new ArrayDeque<RelationshipIndexCursor>();
    private final Queue<RelationshipTypeIndexCursor> relationshipTypeIndexCursors = new ArrayDeque<RelationshipTypeIndexCursor>();

    public StubCursorFactory() {
        this(false);
    }

    public StubCursorFactory(boolean continueWithLastItem) {
        this.continueWithLastItem = continueWithLastItem;
    }

    public NodeCursor allocateNodeCursor(PageCursorTracer cursorTracer) {
        return this.poll(this.nodeCursors);
    }

    public NodeCursor allocateFullAccessNodeCursor(PageCursorTracer cursorTracer) {
        return this.poll(this.fullNodeCursors);
    }

    public RelationshipScanCursor allocateRelationshipScanCursor(PageCursorTracer cursorTracer) {
        return this.poll(this.relationshipScanCursors);
    }

    public RelationshipScanCursor allocateFullAccessRelationshipScanCursor(PageCursorTracer cursorTracer) {
        return this.poll(this.fullRelationshipScanCursors);
    }

    public RelationshipTraversalCursor allocateRelationshipTraversalCursor(PageCursorTracer cursorTracer) {
        return this.poll(this.relationshipTraversalCursors);
    }

    public RelationshipTraversalCursor allocateFullAccessRelationshipTraversalCursor(PageCursorTracer cursorTracer) {
        return this.poll(this.fullRelationshipTraversalCursors);
    }

    public PropertyCursor allocatePropertyCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return this.poll(this.propertyCursors);
    }

    public PropertyCursor allocateFullAccessPropertyCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return this.poll(this.fullPropertyCursors);
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return this.poll(this.nodeValueIndexCursors);
    }

    public NodeValueIndexCursor allocateFullAccessNodeValueIndexCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        return this.poll(this.fullNodeValueIndexCursors);
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor(PageCursorTracer cursorTracer) {
        return this.poll(this.nodeLabelIndexCursors);
    }

    public NodeLabelIndexCursor allocateFullAccessNodeLabelIndexCursor(PageCursorTracer cursorTracer) {
        return this.poll(this.fullNodeLabelIndexCursors);
    }

    public RelationshipIndexCursor allocateRelationshipIndexCursor(PageCursorTracer cursorTracer) {
        return this.poll(this.relationshipIndexCursors);
    }

    public RelationshipTypeIndexCursor allocateRelationshipTypeIndexCursor() {
        return this.poll(this.relationshipTypeIndexCursors);
    }

    public StubCursorFactory withRelationshipTraversalCursors(RelationshipTraversalCursor ... cursors) {
        this.relationshipTraversalCursors.addAll(Arrays.asList(cursors));
        return this;
    }

    private <T> T poll(Queue<T> queue) {
        T poll = queue.poll();
        if (this.continueWithLastItem && queue.isEmpty()) {
            queue.offer(poll);
        }
        return poll;
    }
}

