/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.EntityIndexCursor;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.ValueIndexCursor;
import org.neo4j.values.storable.Value;

public class StubEntityValueIndexCursor
extends DefaultCloseListenable
implements EntityIndexCursor,
ValueIndexCursor {
    private int position = -1;
    protected final List<ValueIndexResult> results = new ArrayList<ValueIndexResult>();
    private boolean closed;

    protected StubEntityValueIndexCursor() {
    }

    public StubEntityValueIndexCursor withEntity(long id, float score, Value ... vs) {
        this.results.add(new ValueIndexResult(id, score, vs));
        return this;
    }

    public StubEntityValueIndexCursor withEntity(long id, Value ... vs) {
        return this.withEntity(id, Float.NaN, vs);
    }

    public long reference() {
        return this.accessResult(result -> result.entityId, () -> -1L);
    }

    public float score() {
        return this.accessResult(result -> Float.valueOf(result.score), () -> Float.valueOf(Float.NaN)).floatValue();
    }

    public boolean next() {
        this.checkOpen();
        return ++this.position < this.results.size();
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("Cursor is closed");
        }
    }

    public void closeInternal() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setTracer(KernelReadTracer tracer) {
    }

    public void removeTracer() {
    }

    public int numberOfProperties() {
        return this.accessResult(result -> result.values().length, () -> 0);
    }

    public boolean hasValue() {
        return this.numberOfProperties() > 0;
    }

    public Value propertyValue(int offset) {
        return this.accessResult(value -> value.values()[offset], () -> {
            throw new NullPointerException();
        });
    }

    protected <T> T accessResult(Function<ValueIndexResult, T> existingResult, Supplier<T> defaultSupplier) {
        return this.position >= 0 && this.position < this.results.size() ? existingResult.apply(this.results.get(this.position)) : defaultSupplier.get();
    }

    record ValueIndexResult(long entityId, float score, Value[] values) {
    }
}

