/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import java.util.Optional;
import java.util.function.Predicate;
import org.neo4j.adversaries.Adversary;

public class StackTraceElementGuardedAdversary
implements Adversary {
    private final Adversary delegate;
    private final Predicate<StackWalker.StackFrame> check;
    private volatile boolean enabled;

    StackTraceElementGuardedAdversary(Adversary delegate, Predicate<StackWalker.StackFrame> check) {
        this.delegate = delegate;
        this.check = check;
        this.enabled = true;
    }

    @Override
    public void injectFailure(Class<? extends Throwable> ... failureTypes) {
        if (this.enabled && this.calledFromVictimStackTraceElement()) {
            this.delegate.injectFailure(failureTypes);
        }
    }

    @Override
    public boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
        return this.enabled && this.calledFromVictimStackTraceElement() && this.delegate.injectFailureOrMischief(failureTypes);
    }

    @Override
    public Optional<Throwable> getLastAdversaryException() {
        return this.delegate.getLastAdversaryException();
    }

    private boolean calledFromVictimStackTraceElement() {
        return StackWalker.getInstance().walk(s -> s.filter(this.check).findAny()).isPresent();
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }
}

