/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.SelectiveFileWatcher;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StreamFilesRecursive;
import org.neo4j.io.fs.watcher.FileWatcher;

public class SelectiveFileSystemAbstraction
implements FileSystemAbstraction {
    private final Path specialFile;
    private final FileSystemAbstraction specialFileSystem;
    private final FileSystemAbstraction defaultFileSystem;

    public SelectiveFileSystemAbstraction(Path specialFile, FileSystemAbstraction specialFileSystem, FileSystemAbstraction defaultFileSystem) {
        this.specialFile = specialFile;
        this.specialFileSystem = specialFileSystem;
        this.defaultFileSystem = defaultFileSystem;
    }

    public FileWatcher fileWatcher() throws IOException {
        return new SelectiveFileWatcher(this.specialFile, this.defaultFileSystem.fileWatcher(), this.specialFileSystem.fileWatcher());
    }

    public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
        return this.chooseFileSystem(fileName).open(fileName, options);
    }

    public OutputStream openAsOutputStream(Path fileName, boolean append) throws IOException {
        return this.chooseFileSystem(fileName).openAsOutputStream(fileName, append);
    }

    public InputStream openAsInputStream(Path fileName) throws IOException {
        return this.chooseFileSystem(fileName).openAsInputStream(fileName);
    }

    public Reader openAsReader(Path fileName, Charset charset) throws IOException {
        return this.chooseFileSystem(fileName).openAsReader(fileName, charset);
    }

    public Writer openAsWriter(Path fileName, Charset charset, boolean append) throws IOException {
        return this.chooseFileSystem(fileName).openAsWriter(fileName, charset, append);
    }

    public StoreChannel write(Path fileName) throws IOException {
        return this.chooseFileSystem(fileName).write(fileName);
    }

    public StoreChannel read(Path fileName) throws IOException {
        return this.chooseFileSystem(fileName).read(fileName);
    }

    public boolean fileExists(Path file) {
        return this.chooseFileSystem(file).fileExists(file);
    }

    public void mkdir(Path fileName) throws IOException {
        this.chooseFileSystem(fileName).mkdir(fileName);
    }

    public void mkdirs(Path fileName) throws IOException {
        this.chooseFileSystem(fileName).mkdirs(fileName);
    }

    public long getFileSize(Path fileName) throws IOException {
        return this.chooseFileSystem(fileName).getFileSize(fileName);
    }

    public long getBlockSize(Path file) throws IOException {
        return this.chooseFileSystem(file).getBlockSize(file);
    }

    public void deleteFile(Path fileName) throws IOException {
        this.chooseFileSystem(fileName).deleteFile(fileName);
    }

    public void deleteRecursively(Path directory) throws IOException {
        this.chooseFileSystem(directory).deleteRecursively(directory);
    }

    public void renameFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.chooseFileSystem(from).renameFile(from, to, copyOptions);
    }

    public Path[] listFiles(Path directory) throws IOException {
        return this.chooseFileSystem(directory).listFiles(directory);
    }

    public Path[] listFiles(Path directory, DirectoryStream.Filter<Path> filter) throws IOException {
        return this.chooseFileSystem(directory).listFiles(directory, filter);
    }

    public boolean isDirectory(Path file) {
        return this.chooseFileSystem(file).isDirectory(file);
    }

    public void moveToDirectory(Path file, Path toDirectory) throws IOException {
        this.chooseFileSystem(file).moveToDirectory(file, toDirectory);
    }

    public void copyToDirectory(Path file, Path toDirectory) throws IOException {
        this.chooseFileSystem(file).copyToDirectory(file, toDirectory);
    }

    public void copyFile(Path from, Path to) throws IOException {
        this.chooseFileSystem(from).copyFile(from, to);
    }

    public void copyFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.chooseFileSystem(from).copyFile(from, to, copyOptions);
    }

    public void copyRecursively(Path fromDirectory, Path toDirectory) throws IOException {
        this.chooseFileSystem(fromDirectory).copyRecursively(fromDirectory, toDirectory);
    }

    public void truncate(Path path, long size) throws IOException {
        this.chooseFileSystem(path).truncate(path, size);
    }

    public long lastModifiedTime(Path file) throws IOException {
        return this.chooseFileSystem(file).lastModifiedTime(file);
    }

    public void deleteFileOrThrow(Path file) throws IOException {
        this.chooseFileSystem(file).deleteFileOrThrow(file);
    }

    public Stream<FileHandle> streamFilesRecursive(Path directory) throws IOException {
        return StreamFilesRecursive.streamFilesRecursive((Path)directory, (FileSystemAbstraction)this);
    }

    public int getFileDescriptor(StoreChannel channel) {
        return this.defaultFileSystem.getFileDescriptor(channel);
    }

    private FileSystemAbstraction chooseFileSystem(Path file) {
        return file.equals(this.specialFile) ? this.specialFileSystem : this.defaultFileSystem;
    }

    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new FileSystemAbstraction[]{this.specialFileSystem, this.defaultFileSystem});
    }
}

