/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.time.Clock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.helpers.collection.CombiningIterator;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.EphemeralFileChannel;
import org.neo4j.io.fs.EphemeralFileData;
import org.neo4j.io.fs.EphemeralFileStillOpenException;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.StreamFilesRecursive;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.impl.ChannelInputStream;
import org.neo4j.test.impl.ChannelOutputStream;

public class EphemeralFileSystemAbstraction
implements FileSystemAbstraction {
    private final Clock clock;
    private final AtomicInteger keepFiles = new AtomicInteger();
    private final Set<File> directories = ConcurrentHashMap.newKeySet();
    private final Map<File, EphemeralFileData> files;
    private volatile boolean closed;

    public EphemeralFileSystemAbstraction() {
        this(Clock.systemUTC());
    }

    public EphemeralFileSystemAbstraction(Clock clock) {
        this.clock = clock;
        this.files = new ConcurrentHashMap<File, EphemeralFileData>();
        this.initCurrentWorkingDirectory();
    }

    private void initCurrentWorkingDirectory() {
        try {
            this.mkdirs(new File(".").getCanonicalFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException("EphemeralFileSystemAbstraction could not initialise current working directory", e);
        }
    }

    private EphemeralFileSystemAbstraction(Set<File> directories, Map<File, EphemeralFileData> files, Clock clock) {
        this.clock = clock;
        this.files = new ConcurrentHashMap<File, EphemeralFileData>(files);
        this.directories.addAll(directories);
        this.initCurrentWorkingDirectory();
    }

    public void clear() {
        this.closeFiles();
    }

    public void crash() {
        this.files.values().forEach(EphemeralFileData::crash);
    }

    public Resource keepFiles() {
        this.keepFiles.getAndIncrement();
        return this.keepFiles::decrementAndGet;
    }

    public synchronized void close() throws IOException {
        if (this.keepFiles.get() > 0) {
            return;
        }
        this.closeFiles();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void closeFiles() {
        for (EphemeralFileData file : this.files.values()) {
            file.free();
        }
        this.files.clear();
    }

    public void assertNoOpenFiles() throws Exception {
        Throwable exception = null;
        for (EphemeralFileData file : this.files.values()) {
            Iterator<EphemeralFileChannel> channels = file.getOpenChannels();
            while (channels.hasNext()) {
                EphemeralFileChannel channel = channels.next();
                if (exception == null) {
                    exception = new IOException("Expected no open files. The stack traces of the currently open files are attached as suppressed exceptions.");
                }
                exception.addSuppressed(channel.openedAt);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public FileWatcher fileWatcher() {
        return FileWatcher.SILENT_WATCHER;
    }

    public synchronized StoreChannel open(File fileName, Set<OpenOption> options) throws IOException {
        return this.getStoreChannel(fileName);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return new ChannelOutputStream(this.write(fileName), append, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return new ChannelInputStream(this.read(fileName), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), charset);
    }

    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append), charset);
    }

    public synchronized StoreChannel write(File fileName) throws IOException {
        File parentFile = fileName.getParentFile();
        if (parentFile != null && !this.fileExists(parentFile)) {
            throw new FileNotFoundException("'" + fileName + "' (The system cannot find the path specified)");
        }
        EphemeralFileData data = this.files.computeIfAbsent(EphemeralFileSystemAbstraction.canonicalFile(fileName), key -> new EphemeralFileData((File)key, this.clock));
        return new StoreFileChannel((FileChannel)new EphemeralFileChannel(data, new EphemeralFileStillOpenException(fileName.getPath())));
    }

    public synchronized StoreChannel read(File fileName) throws IOException {
        return this.getStoreChannel(fileName);
    }

    public long getFileSize(File fileName) {
        EphemeralFileData file = this.files.get(EphemeralFileSystemAbstraction.canonicalFile(fileName));
        return file == null ? 0L : file.size();
    }

    public long getBlockSize(File file) {
        return 512L;
    }

    public boolean fileExists(File file) {
        return this.directories.contains(file = EphemeralFileSystemAbstraction.canonicalFile(file)) || this.files.containsKey(file);
    }

    private static File canonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException("EphemeralFileSystemAbstraction could not canonicalise file: " + file, e);
        }
    }

    public boolean isDirectory(File file) {
        return this.directories.contains(EphemeralFileSystemAbstraction.canonicalFile(file));
    }

    public boolean mkdir(File directory) {
        if (this.fileExists(directory)) {
            return false;
        }
        this.directories.add(EphemeralFileSystemAbstraction.canonicalFile(directory));
        return true;
    }

    public void mkdirs(File directory) throws IOException {
        for (File currentDirectory = EphemeralFileSystemAbstraction.canonicalFile(directory); currentDirectory != null; currentDirectory = currentDirectory.getParentFile()) {
            if (this.files.containsKey(currentDirectory)) {
                throw new IOException(String.format("Unable to write directory path [%s] for Neo4j store.", currentDirectory));
            }
            this.mkdir(currentDirectory);
        }
    }

    public boolean deleteFile(File fileName) {
        EphemeralFileData removed = this.files.remove(fileName = EphemeralFileSystemAbstraction.canonicalFile(fileName));
        if (removed != null) {
            removed.free();
            return true;
        }
        File[] fileList = this.listFiles(fileName);
        return fileList != null && fileList.length == 0 && this.directories.remove(fileName);
    }

    public void deleteRecursively(File path) {
        if (this.isDirectory(path)) {
            List<String> directoryPathItems = this.splitPath(EphemeralFileSystemAbstraction.canonicalFile(path));
            for (Map.Entry<File, EphemeralFileData> file : this.files.entrySet()) {
                File fileName = file.getKey();
                List<String> fileNamePathItems = this.splitPath(fileName);
                if (!this.directoryMatches(directoryPathItems, fileNamePathItems)) continue;
                this.deleteFile(fileName);
            }
            for (File subDirectory : this.directories) {
                List<String> subDirectoryPathItems = this.splitPath(subDirectory);
                if (!this.directoryMatches(directoryPathItems, subDirectoryPathItems)) continue;
                this.deleteFile(subDirectory);
            }
        }
        this.deleteFile(path);
    }

    public void renameFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        from = EphemeralFileSystemAbstraction.canonicalFile(from);
        to = EphemeralFileSystemAbstraction.canonicalFile(to);
        if (!this.files.containsKey(from)) {
            throw new NoSuchFileException("'" + from + "' doesn't exist");
        }
        boolean replaceExisting = false;
        for (CopyOption copyOption : copyOptions) {
            replaceExisting |= copyOption == StandardCopyOption.REPLACE_EXISTING;
        }
        if (this.files.containsKey(to) && !replaceExisting) {
            throw new FileAlreadyExistsException("'" + to + "' already exists");
        }
        if (!this.isDirectory(to.getParentFile())) {
            throw new NoSuchFileException("Target directory[" + to.getParent() + "] does not exists");
        }
        this.files.put(to, this.files.remove(from));
    }

    public File[] listFiles(File directory) {
        if (this.files.containsKey(directory = EphemeralFileSystemAbstraction.canonicalFile(directory)) || !this.directories.contains(directory)) {
            return null;
        }
        List<String> directoryPathItems = this.splitPath(directory);
        HashSet<File> found = new HashSet<File>();
        CombiningIterator filesAndFolders = new CombiningIterator(Arrays.asList(this.files.keySet().iterator(), this.directories.iterator()));
        while (filesAndFolders.hasNext()) {
            File file = (File)filesAndFolders.next();
            List<String> fileNamePathItems = this.splitPath(file);
            if (!this.directoryMatches(directoryPathItems, fileNamePathItems)) continue;
            found.add(EphemeralFileSystemAbstraction.constructPath(fileNamePathItems, directoryPathItems));
        }
        return found.toArray(new File[0]);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        if (this.files.containsKey(directory = EphemeralFileSystemAbstraction.canonicalFile(directory))) {
            return null;
        }
        List<String> directoryPathItems = this.splitPath(directory);
        HashSet<File> found = new HashSet<File>();
        CombiningIterator files = new CombiningIterator(Arrays.asList(this.files.keySet().iterator(), this.directories.iterator()));
        while (files.hasNext()) {
            File path;
            File file = (File)files.next();
            List<String> fileNamePathItems = this.splitPath(file);
            if (!this.directoryMatches(directoryPathItems, fileNamePathItems) || !filter.accept((path = EphemeralFileSystemAbstraction.constructPath(fileNamePathItems, directoryPathItems)).getParentFile(), path.getName())) continue;
            found.add(path);
        }
        return found.toArray(new File[0]);
    }

    private static File constructPath(List<String> pathItems, List<String> base) {
        File file = null;
        if (!base.isEmpty()) {
            pathItems = pathItems.subList(0, base.size() + 1);
        }
        for (String pathItem : pathItems) {
            String pathItemName = pathItem + File.separator;
            file = file == null ? new File(pathItemName) : new File(file, pathItemName);
        }
        return file;
    }

    private boolean directoryMatches(List<String> directoryPathItems, List<String> fileNamePathItems) {
        return fileNamePathItems.size() > directoryPathItems.size() && fileNamePathItems.subList(0, directoryPathItems.size()).equals(directoryPathItems);
    }

    private StoreChannel getStoreChannel(File fileName) throws IOException {
        EphemeralFileData data = this.files.get(EphemeralFileSystemAbstraction.canonicalFile(fileName));
        if (data != null) {
            return new StoreFileChannel((FileChannel)new EphemeralFileChannel(data, new EphemeralFileStillOpenException(fileName.getPath())));
        }
        return this.write(fileName);
    }

    private List<String> splitPath(File path) {
        return Arrays.asList(path.getPath().replaceAll("\\\\", "/").split("/"));
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        if (this.isDirectory(file)) {
            File inner = new File(toDirectory, file.getName());
            this.mkdir(inner);
            for (File f : this.listFiles(file)) {
                this.moveToDirectory(f, inner);
            }
            this.deleteFile(file);
        } else {
            EphemeralFileData fileToMove = this.files.remove(EphemeralFileSystemAbstraction.canonicalFile(file));
            if (fileToMove == null) {
                throw new FileNotFoundException(file.getPath());
            }
            this.files.put(EphemeralFileSystemAbstraction.canonicalFile(new File(toDirectory, file.getName())), fileToMove);
        }
    }

    public void copyToDirectory(File file, File toDirectory) throws IOException {
        File targetFile = new File(toDirectory, file.getName());
        this.copyFile(file, targetFile);
    }

    public void copyFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        EphemeralFileData data = this.files.get(EphemeralFileSystemAbstraction.canonicalFile(from));
        if (data == null) {
            throw new FileNotFoundException("File " + from + " not found");
        }
        if (!ArrayUtils.contains((Object[])copyOptions, (Object)StandardCopyOption.REPLACE_EXISTING) && this.files.get(EphemeralFileSystemAbstraction.canonicalFile(from)) != null) {
            throw new FileAlreadyExistsException(to.getAbsolutePath());
        }
        this.copyFile(from, this, to, EphemeralFileSystemAbstraction.newCopyBuffer());
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.copyRecursivelyFromOtherFs(fromDirectory, this, toDirectory, EphemeralFileSystemAbstraction.newCopyBuffer());
    }

    public synchronized EphemeralFileSystemAbstraction snapshot() {
        HashMap<File, EphemeralFileData> copiedFiles = new HashMap<File, EphemeralFileData>();
        for (Map.Entry<File, EphemeralFileData> file : this.files.entrySet()) {
            copiedFiles.put(file.getKey(), file.getValue().copy());
        }
        return new EphemeralFileSystemAbstraction(this.directories, copiedFiles, this.clock);
    }

    private void copyRecursivelyFromOtherFs(File from, FileSystemAbstraction fromFs, File to) throws IOException {
        this.copyRecursivelyFromOtherFs(from, fromFs, to, EphemeralFileSystemAbstraction.newCopyBuffer());
    }

    private static ByteBuffer newCopyBuffer() {
        return ByteBuffers.allocate((int)1, (ByteUnit)ByteUnit.MebiByte, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private void copyRecursivelyFromOtherFs(File from, FileSystemAbstraction fromFs, File to, ByteBuffer buffer) throws IOException {
        this.mkdirs(to);
        for (File fromFile : fromFs.listFiles(from)) {
            File toFile = new File(to, fromFile.getName());
            if (fromFs.isDirectory(fromFile)) {
                this.copyRecursivelyFromOtherFs(fromFile, fromFs, toFile);
                continue;
            }
            this.copyFile(fromFile, fromFs, toFile, buffer);
        }
    }

    private void copyFile(File from, FileSystemAbstraction fromFs, File to, ByteBuffer buffer) throws IOException {
        try (StoreChannel source = fromFs.read(from);
             StoreChannel sink = this.write(to);){
            int available;
            sink.truncate(0L);
            long sourceSize = source.size();
            while ((available = (int)(sourceSize - source.position())) > 0) {
                buffer.clear();
                buffer.limit(Math.min(available, buffer.capacity()));
                source.read(buffer);
                buffer.flip();
                sink.write(buffer);
            }
        }
    }

    public void truncate(File file, long size) throws IOException {
        EphemeralFileData data = this.files.get(EphemeralFileSystemAbstraction.canonicalFile(file));
        if (data == null) {
            throw new FileNotFoundException("File " + file + " not found");
        }
        data.truncate(size);
    }

    public long lastModifiedTime(File file) {
        EphemeralFileData data = this.files.get(EphemeralFileSystemAbstraction.canonicalFile(file));
        if (data == null) {
            return 0L;
        }
        return data.getLastModified();
    }

    public void deleteFileOrThrow(File file) throws IOException {
        if (!this.fileExists(file = EphemeralFileSystemAbstraction.canonicalFile(file))) {
            throw new NoSuchFileException(file.getAbsolutePath());
        }
        if (!this.deleteFile(file)) {
            throw new IOException("Could not delete file: " + file);
        }
    }

    public Stream<FileHandle> streamFilesRecursive(File directory) throws IOException {
        return StreamFilesRecursive.streamFilesRecursive((File)directory, (FileSystemAbstraction)this);
    }

    public int getFileDescriptor(StoreChannel channel) {
        return -1;
    }
}

