/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.neo4j.common.EntityType;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.DataGeneratorInput;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class SimpleRandomizedInput
implements Input {
    public static final String ID_KEY = "id";
    private final Input actual;
    private final long nodeCount;
    private final long relationshipCount;

    public SimpleRandomizedInput(long seed, long nodeCount, long relationshipCount) {
        this(seed, DataGeneratorInput.data(nodeCount, relationshipCount), 0, 0, null);
    }

    public SimpleRandomizedInput(long seed, DataGeneratorInput.DataDistribution dataDistribution, int maxAdditionalNodeProperties, int maxAdditionalRelationshipProperties, String labelNameForIncrementalImport) {
        this.nodeCount = dataDistribution.nodeCount();
        this.relationshipCount = dataDistribution.relationshipCount();
        IdType idType = IdType.INTEGER;
        Extractors extractors = new Extractors(Configuration.COMMAS.arrayDelimiter());
        Groups groups = new Groups();
        Group group = groups.getOrCreate(null);
        ArrayList<Header.Entry> additionalRelationshipEntries = new ArrayList<Header.Entry>();
        additionalRelationshipEntries.add(new Header.Entry(ID_KEY, Type.PROPERTY, null, extractors.int_()));
        additionalRelationshipEntries.addAll(Arrays.asList(this.additionalPropertyEntries(maxAdditionalRelationshipProperties, group, extractors, seed)));
        Header.Entry[] additionalNodeHeaderEntries = this.additionalPropertyEntries(maxAdditionalNodeProperties, group, extractors, seed);
        Header nodeHeader = labelNameForIncrementalImport != null ? DataGeneratorInput.bareboneIncrementalNodeHeader(ID_KEY, labelNameForIncrementalImport, idType, group, extractors, additionalNodeHeaderEntries) : DataGeneratorInput.bareboneNodeHeader(ID_KEY, idType, group, extractors, additionalNodeHeaderEntries);
        this.actual = new DataGeneratorInput(dataDistribution, idType, seed, nodeHeader, DataGeneratorInput.bareboneRelationshipHeader(idType, group, extractors, additionalRelationshipEntries.toArray(new Header.Entry[0])), groups);
    }

    private Header.Entry[] additionalPropertyEntries(int count, Group group, Extractors extractors, long seed) {
        Header.Entry[] entries = new Header.Entry[count];
        Random rng = new Random(seed);
        for (int i = 0; i < count; ++i) {
            entries[i] = new Header.Entry("p" + i, Type.PROPERTY, group, this.randomType(extractors, rng));
        }
        return entries;
    }

    private Extractor<?> randomType(Extractors extractors, Random random) {
        return switch (random.nextInt(12)) {
            case 0 -> extractors.byte_();
            case 1 -> extractors.short_();
            case 2 -> extractors.int_();
            case 3 -> extractors.long_();
            case 4 -> extractors.string();
            case 5 -> extractors.boolean_();
            case 6 -> extractors.byteArray();
            case 7 -> extractors.shortArray();
            case 8 -> extractors.intArray();
            case 9 -> extractors.longArray();
            case 10 -> extractors.stringArray();
            case 11 -> extractors.booleanArray();
            default -> throw new IllegalArgumentException();
        };
    }

    public InputIterable nodes(Collector badCollector) {
        return this.actual.nodes(badCollector);
    }

    public InputIterable relationships(Collector badCollector) {
        return this.actual.relationships(badCollector);
    }

    public IdType idType() {
        return this.actual.idType();
    }

    public ReadableGroups groups() {
        return this.actual.groups();
    }

    public Map<String, SchemaDescriptor> referencedNodeSchema(TokenHolders tokenHolders) {
        return this.actual.referencedNodeSchema(tokenHolders);
    }

    public void verify(GraphDatabaseService db) throws IOException {
        this.verify(db, false);
    }

    public void verifyWithTokenIndexes(GraphDatabaseService db) throws IOException {
        this.verify(db, true);
    }

    public void verify(GraphDatabaseService db, boolean verifyIndex) throws IOException {
        SimpleRandomizedInput.verify(db, verifyIndex, this);
    }

    public static void verify(GraphDatabaseService db, boolean verifyIndex, SimpleRandomizedInput ... inputs) throws IOException {
        HashMap<Number, InputEntity> expectedNodeData = new HashMap<Number, InputEntity>();
        long numBadNodes = 0L;
        long nodeCount = 0L;
        for (SimpleRandomizedInput input : inputs) {
            nodeCount += input.nodeCount;
            try (InputIterator nodes = input.nodes(Collector.EMPTY).iterator();
                 InputChunk chunk = nodes.newChunk();
                 Transaction tx = db.beginTx();){
                while (nodes.next(chunk)) {
                    InputEntity node2;
                    while (chunk.next((InputEntityVisitor)(node2 = new InputEntity()))) {
                        Number id = (Number)node2.id();
                        if (!expectedNodeData.containsKey(id)) {
                            expectedNodeData.put(id, node2);
                            continue;
                        }
                        ++numBadNodes;
                    }
                }
            }
        }
        HashMap<RelationshipKey, Set> expectedRelationshipData = new HashMap<RelationshipKey, Set>();
        long numBadRelationships = 0L;
        long relationshipCount = 0L;
        for (InputChunk input : inputs) {
            relationshipCount += input.relationshipCount;
            try (ResourceIterator relationships = input.relationships(Collector.EMPTY).iterator();
                 InputChunk chunk = relationships.newChunk();){
                while (relationships.next(chunk)) {
                    InputEntity relationship2;
                    while (chunk.next((InputEntityVisitor)(relationship2 = new InputEntity()))) {
                        RelationshipKey key = new RelationshipKey(relationship2.startId(), relationship2.stringType, relationship2.endId());
                        if (key.startId != null && key.type != null && key.endId != null && expectedNodeData.containsKey((Number)relationship2.startId()) && expectedNodeData.containsKey((Number)relationship2.endId())) {
                            expectedRelationshipData.computeIfAbsent(key, k -> new HashSet()).add(relationship2);
                            continue;
                        }
                        ++numBadRelationships;
                    }
                }
            }
        }
        try (Transaction tx = db.beginTx();
             ResourceIterable allRelationships = tx.getAllRelationships();){
            long actualRelationshipCount = 0L;
            for (Relationship relationship3 : allRelationships) {
                RelationshipKey key = SimpleRandomizedInput.keyOf(relationship3);
                Set matches = (Set)expectedRelationshipData.get(key);
                Assertions.assertNotNull((Object)matches);
                InputEntity matchingRelationship = SimpleRandomizedInput.relationshipWithId(matches, relationship3);
                Assertions.assertNotNull((Object)matchingRelationship);
                Assertions.assertTrue((boolean)matches.remove(matchingRelationship));
                if (matches.isEmpty()) {
                    expectedRelationshipData.remove(key);
                }
                ++actualRelationshipCount;
            }
            if (!expectedRelationshipData.isEmpty()) {
                Assertions.fail((String)String.format("Imported db is missing %d/%d relationships: %s", expectedRelationshipData.size(), relationshipCount, expectedRelationshipData));
            }
            long actualNodeCount = 0L;
            try (ResourceIterable allNodes = tx.getAllNodes();){
                for (Node node3 : allNodes) {
                    Assertions.assertNotNull(expectedNodeData.remove(node3.getProperty(ID_KEY)));
                    ++actualNodeCount;
                }
            }
            if (!expectedNodeData.isEmpty()) {
                Assertions.fail((String)String.format("Imported db is missing %d/%d nodes: %s", expectedNodeData.size(), nodeCount, expectedNodeData));
            }
            Assertions.assertEquals((long)(nodeCount - numBadNodes), (long)actualNodeCount);
            Assertions.assertEquals((long)(relationshipCount - numBadRelationships), (long)actualRelationshipCount);
            tx.commit();
        }
        if (verifyIndex) {
            HashMap<Integer, List<Long>> expectedLabelIndexData = new HashMap<Integer, List<Long>>();
            HashMap<Integer, List<Long>> expectedRelationshipIndexData = new HashMap<Integer, List<Long>>();
            try (Transaction tx = db.beginTx();
                 ResourceIterable allNodes = tx.getAllNodes();
                 ResourceIterable allRelationships = tx.getAllRelationships();){
                TokenRead tokenRead = ((InternalTransaction)tx).kernelTransaction().tokenRead();
                allNodes.forEach(node -> {
                    for (Label label : node.getLabels()) {
                        int labelId = tokenRead.nodeLabel(label.name());
                        expectedLabelIndexData.computeIfAbsent(labelId, labelToken -> new ArrayList()).add(node.getId());
                    }
                });
                allRelationships.forEach(relationship -> {
                    int relTypeId = tokenRead.relationshipType(relationship.getType().name());
                    expectedRelationshipIndexData.computeIfAbsent(relTypeId, relToken -> new ArrayList()).add(relationship.getId());
                });
            }
            SimpleRandomizedInput.verifyIndex(EntityType.NODE, expectedLabelIndexData, db);
            SimpleRandomizedInput.verifyIndex(EntityType.RELATIONSHIP, expectedRelationshipIndexData, db);
        }
    }

    private static void verifyIndex(EntityType entity, Map<Integer, List<Long>> expectedIds, GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            InternalTransaction internalTx = (InternalTransaction)tx;
            KernelTransaction ktx = internalTx.kernelTransaction();
            SchemaRead schemaRead = ktx.schemaRead();
            IndexDescriptor index = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)entity)));
            TokenReadSession session = ktx.dataRead().tokenReadSession(index);
            try (NodeLabelIndexCursor nodeCursor = ktx.cursors().allocateNodeLabelIndexCursor(CursorContext.NULL_CONTEXT);
                 RelationshipTypeIndexCursor relationshipCursor = ktx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL_CONTEXT);){
                expectedIds.forEach((tokenId, expectedEntities) -> {
                    try {
                        ArrayList<Long> actualEntities = new ArrayList<Long>();
                        if (entity == EntityType.NODE) {
                            ktx.dataRead().nodeLabelScan(session, nodeCursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(tokenId.intValue()), CursorContext.NULL_CONTEXT);
                            while (nodeCursor.next()) {
                                actualEntities.add(nodeCursor.nodeReference());
                            }
                        } else {
                            ktx.dataRead().relationshipTypeScan(session, relationshipCursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(tokenId.intValue()), CursorContext.NULL_CONTEXT);
                            while (relationshipCursor.next()) {
                                actualEntities.add(relationshipCursor.relationshipReference());
                            }
                        }
                        expectedEntities.sort(Long::compareTo);
                        actualEntities.sort(Long::compareTo);
                        Assertions.assertEquals((Object)expectedEntities, actualEntities);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (IndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputEntity relationshipWithId(Set<InputEntity> matches, Relationship relationship) {
        Map<String, Value> dbProperties = SimpleRandomizedInput.toValueMap(relationship.getAllProperties());
        for (InputEntity candidate : matches) {
            if (!dbProperties.equals(SimpleRandomizedInput.propertiesOf(candidate))) continue;
            return candidate;
        }
        return null;
    }

    private static Map<String, Value> toValueMap(Map<String, Object> map) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        map.forEach((key, value) -> result.put((String)key, Values.of((Object)value)));
        return result;
    }

    private static Map<String, Value> propertiesOf(InputEntity entity) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        Object[] properties = entity.properties();
        for (int i = 0; i < properties.length; ++i) {
            result.put((String)properties[i++], Values.of((Object)properties[i]));
        }
        return result;
    }

    private static RelationshipKey keyOf(Relationship relationship) {
        return new RelationshipKey(relationship.getStartNode().getProperty(ID_KEY), relationship.getType().name(), relationship.getEndNode().getProperty(ID_KEY));
    }

    public Input.Estimates calculateEstimates(PropertySizeCalculator valueSizeCalculator) throws IOException {
        return Input.knownEstimates((long)this.nodeCount, (long)this.relationshipCount, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L);
    }

    private record RelationshipKey(Object startId, String type, Object endId) {
    }
}

