/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.bolt.connection.values.Type;
import org.neo4j.driver.exceptions.value.LossyCoercion;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.NumberValueAdapter;

public class FloatValue
extends NumberValueAdapter<Double> {
    private final double val;

    public FloatValue(double val) {
        this.val = val;
    }

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.FLOAT();
    }

    public Type boltValueType() {
        return Type.FLOAT;
    }

    @Override
    public Double asNumber() {
        return this.val;
    }

    @Override
    public long asLong() {
        long longVal = (long)this.val;
        if ((double)longVal != this.val) {
            throw new LossyCoercion(this.type().name(), "Java long");
        }
        return longVal;
    }

    @Override
    public int asInt() {
        int intVal = (int)this.val;
        if ((double)intVal != this.val) {
            throw new LossyCoercion(this.type().name(), "Java int");
        }
        return intVal;
    }

    @Override
    public double asDouble() {
        return this.val;
    }

    @Override
    public float asFloat() {
        float floatVal = (float)this.val;
        if ((double)floatVal != this.val) {
            throw new LossyCoercion(this.type().name(), "Java float");
        }
        return floatVal;
    }

    @Override
    public <T> T as(Class<T> targetClass) {
        if (targetClass.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.asDouble());
        }
        if (targetClass.isAssignableFrom(Double.class)) {
            return targetClass.cast(this.asDouble());
        }
        if (targetClass.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.asLong());
        }
        if (targetClass.equals(Long.class)) {
            return targetClass.cast(this.asLong());
        }
        if (targetClass.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.asInt());
        }
        if (targetClass.equals(Integer.class)) {
            return targetClass.cast(this.asInt());
        }
        if (targetClass.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.asFloat());
        }
        if (targetClass.equals(Float.class)) {
            return targetClass.cast(Float.valueOf(this.asFloat()));
        }
        throw new Uncoercible(this.type().name(), targetClass.getCanonicalName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatValue values = (FloatValue)o;
        return Double.compare(values.val, this.val) == 0;
    }

    @Override
    public int hashCode() {
        long temp = Double.doubleToLongBits(this.val);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public String toString() {
        return Double.toString(this.val);
    }
}

