/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.NotificationSeverity;
import org.neo4j.driver.Query;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ProtocolException;
import org.neo4j.driver.internal.InternalNotificationSeverity;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.summary.InternalDatabaseInfo;
import org.neo4j.driver.internal.summary.InternalGqlNotification;
import org.neo4j.driver.internal.summary.InternalGqlStatusObject;
import org.neo4j.driver.internal.summary.InternalInputPosition;
import org.neo4j.driver.internal.summary.InternalNotification;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.internal.summary.InternalProfiledPlan;
import org.neo4j.driver.internal.summary.InternalResultSummary;
import org.neo4j.driver.internal.summary.InternalServerInfo;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.GqlStatusObject;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ProfiledPlan;
import org.neo4j.driver.summary.QueryType;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;

public class MetadataExtractor {
    public static final int ABSENT_QUERY_ID = -1;
    private static final String UNEXPECTED_TYPE_MSG_FMT = "Unexpected query type '%s', consider updating the driver";
    private static final Function<String, ProtocolException> UNEXPECTED_TYPE_EXCEPTION_SUPPLIER = type -> new ProtocolException(String.format(UNEXPECTED_TYPE_MSG_FMT, type));
    private static final Comparator<GqlStatusObject> GQL_STATUS_OBJECT_COMPARATOR = Comparator.comparingInt(gqlStatusObject -> {
        String status = gqlStatusObject.gqlStatus();
        if (status.startsWith("02")) {
            return 0;
        }
        if (status.startsWith("01")) {
            return 1;
        }
        if (status.startsWith("00")) {
            return 2;
        }
        if (status.startsWith("03")) {
            return 3;
        }
        return 4;
    });
    private final String resultConsumedAfterMetadataKey;

    public MetadataExtractor(String resultConsumedAfterMetadataKey) {
        this.resultConsumedAfterMetadataKey = resultConsumedAfterMetadataKey;
    }

    public ResultSummary extractSummary(Query query, DriverBoltConnection connection, long resultAvailableAfter, Map<String, Value> metadata, boolean legacyNotifications, GqlStatusObject gqlStatusObject) {
        List<Notification> notifications;
        Set<GqlStatusObject> gqlStatusObjects;
        InternalServerInfo serverInfo = new InternalServerInfo(connection.serverAgent(), connection.serverAddress(), connection.protocolVersion());
        DatabaseInfo dbInfo = MetadataExtractor.extractDatabaseInfo(metadata);
        if (legacyNotifications) {
            GqlStatusObjectsAndNotifications gqlStatusObjectsAndNotifications = MetadataExtractor.generateGqlStatusObjectsAndExtractNotifications(metadata).collect(Collectors.teeing(Collectors.mapping(GqlStatusObjectAndNotification::gqlStatusObject, Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<GqlStatusObject>(GQL_STATUS_OBJECT_COMPARATOR)), set -> {
                if (gqlStatusObject != null) {
                    set.add(gqlStatusObject);
                }
                return Collections.unmodifiableSet(set);
            })), Collectors.mapping(GqlStatusObjectAndNotification::notification, Collectors.toUnmodifiableList()), GqlStatusObjectsAndNotifications::new));
            gqlStatusObjects = gqlStatusObjectsAndNotifications.gqlStatusObjects();
            notifications = gqlStatusObjectsAndNotifications.notifications();
        } else {
            GqlStatusObjectsAndNotifications gqlStatusObjectsAndNotifications = MetadataExtractor.extractGqlStatusObjectsAndGenerateNotifications(metadata).collect(Collectors.teeing(Collectors.mapping(GqlStatusObjectAndNotification::gqlStatusObject, Collectors.collectingAndThen(Collectors.toCollection(() -> new LinkedHashSet()), Collections::unmodifiableSet)), Collectors.mapping(GqlStatusObjectAndNotification::notification, Collectors.filtering(Objects::nonNull, Collectors.toUnmodifiableList())), GqlStatusObjectsAndNotifications::new));
            gqlStatusObjects = gqlStatusObjectsAndNotifications.gqlStatusObjects();
            notifications = gqlStatusObjectsAndNotifications.notifications();
        }
        return new InternalResultSummary(query, serverInfo, dbInfo, MetadataExtractor.extractQueryType(metadata), MetadataExtractor.extractCounters(metadata), MetadataExtractor.extractPlan(metadata), MetadataExtractor.extractProfiledPlan(metadata), notifications, gqlStatusObjects, resultAvailableAfter, MetadataExtractor.extractResultConsumedAfter(metadata, this.resultConsumedAfterMetadataKey));
    }

    static DatabaseInfo extractDatabaseInfo(Map<String, Value> metadata) {
        Value dbValue = metadata.get("db");
        if (dbValue == null || dbValue.isNull()) {
            return InternalDatabaseInfo.DEFAULT_DATABASE_INFO;
        }
        return new InternalDatabaseInfo(dbValue.asString());
    }

    private static QueryType extractQueryType(Map<String, Value> metadata) {
        Value typeValue = metadata.get("type");
        if (typeValue != null) {
            return QueryType.fromCode(typeValue.asString(), UNEXPECTED_TYPE_EXCEPTION_SUPPLIER);
        }
        return null;
    }

    private static InternalSummaryCounters extractCounters(Map<String, Value> metadata) {
        Value countersValue = metadata.get("stats");
        if (countersValue != null) {
            return new InternalSummaryCounters(MetadataExtractor.counterValue(countersValue, "nodes-created"), MetadataExtractor.counterValue(countersValue, "nodes-deleted"), MetadataExtractor.counterValue(countersValue, "relationships-created"), MetadataExtractor.counterValue(countersValue, "relationships-deleted"), MetadataExtractor.counterValue(countersValue, "properties-set"), MetadataExtractor.counterValue(countersValue, "labels-added"), MetadataExtractor.counterValue(countersValue, "labels-removed"), MetadataExtractor.counterValue(countersValue, "indexes-added"), MetadataExtractor.counterValue(countersValue, "indexes-removed"), MetadataExtractor.counterValue(countersValue, "constraints-added"), MetadataExtractor.counterValue(countersValue, "constraints-removed"), MetadataExtractor.counterValue(countersValue, "system-updates"));
        }
        return null;
    }

    private static int counterValue(Value countersValue, String name) {
        Value value = countersValue.get(name);
        return value.isNull() ? 0 : value.asInt();
    }

    private static Plan extractPlan(Map<String, Value> metadata) {
        Value planValue = metadata.get("plan");
        if (planValue != null) {
            return InternalPlan.EXPLAIN_PLAN_FROM_VALUE.apply(planValue);
        }
        return null;
    }

    private static ProfiledPlan extractProfiledPlan(Map<String, Value> metadata) {
        Value profiledPlanValue = metadata.get("profile");
        if (profiledPlanValue != null) {
            return InternalProfiledPlan.PROFILED_PLAN_FROM_VALUE.apply(profiledPlanValue);
        }
        return null;
    }

    private static Stream<GqlStatusObjectAndNotification> generateGqlStatusObjectsAndExtractNotifications(Map<String, Value> metadata) {
        Value notificationsValue = metadata.get("notifications");
        if (notificationsValue != null && TypeSystem.getDefault().LIST().isTypeOf(notificationsValue)) {
            Iterable<GqlStatusObjectAndNotification> iterable = notificationsValue.values(value -> {
                String code = value.get("code").asString();
                String title = value.get("title").asString();
                String description = value.get("description").asString();
                String rawSeverityLevel = value.containsKey("severity") ? value.get("severity").asString() : null;
                NotificationSeverity severityLevel = InternalNotificationSeverity.valueOf(rawSeverityLevel).orElse(null);
                String rawCategory = value.containsKey("category") ? value.get("category").asString() : null;
                NotificationCategory category = InternalNotification.valueOf(rawCategory).orElse(null);
                Value posValue = value.get("position");
                InternalInputPosition position = null;
                if (posValue != NullValue.NULL) {
                    position = new InternalInputPosition(posValue.get("offset").asInt(), posValue.get("line").asInt(), posValue.get("column").asInt());
                }
                String gqlStatusCode = "03N42";
                String gqlStatusDescription = description;
                if (NotificationSeverity.WARNING.equals(severityLevel)) {
                    gqlStatusCode = "01N42";
                    if (gqlStatusDescription == null || "null".equals(gqlStatusDescription)) {
                        gqlStatusDescription = "warn: unknown warning";
                    }
                } else if (gqlStatusDescription == null || "null".equals(gqlStatusDescription)) {
                    gqlStatusDescription = "info: unknown notification";
                }
                HashMap<String, Value> diagnosticRecord = new HashMap<String, Value>(3);
                diagnosticRecord.put("OPERATION", Values.value(""));
                diagnosticRecord.put("OPERATION_CODE", Values.value("0"));
                diagnosticRecord.put("CURRENT_SCHEMA", Values.value("/"));
                if (rawSeverityLevel != null) {
                    diagnosticRecord.put("_severity", Values.value(rawSeverityLevel));
                }
                if (rawCategory != null) {
                    diagnosticRecord.put("_classification", Values.value(rawCategory));
                }
                if (position != null) {
                    diagnosticRecord.put("_position", Values.value(Map.of("offset", Values.value(position.offset()), "line", Values.value(position.line()), "column", Values.value(position.column()))));
                }
                InternalGqlNotification gqlNotification = new InternalGqlNotification(gqlStatusCode, gqlStatusDescription, Collections.unmodifiableMap(diagnosticRecord), position, severityLevel, rawSeverityLevel, (NotificationClassification)category, rawCategory);
                InternalNotification notification = new InternalNotification(code, title, description, severityLevel, rawSeverityLevel, category, rawCategory, position);
                return new GqlStatusObjectAndNotification(gqlNotification, notification);
            });
            return StreamSupport.stream(iterable.spliterator(), false);
        }
        return Stream.empty();
    }

    private static Stream<GqlStatusObjectAndNotification> extractGqlStatusObjectsAndGenerateNotifications(Map<String, Value> metadata) {
        Value statuses = metadata.get("statuses");
        if (statuses != null && TypeSystem.getDefault().LIST().isTypeOf(statuses)) {
            Iterable<GqlStatusObjectAndNotification> iterable = statuses.values(MetadataExtractor::extractGqlStatusObjectAndGenerateNotification);
            return StreamSupport.stream(iterable.spliterator(), false);
        }
        return Stream.empty();
    }

    private static GqlStatusObjectAndNotification extractGqlStatusObjectAndGenerateNotification(Value value) {
        OptionalInt column;
        OptionalInt line;
        OptionalInt offset;
        Map<Object, Object> diagnosticRecord;
        String status = value.get("gql_status").asString();
        String description = value.get("status_description").asString();
        Value diagnosticRecordValue = value.get("diagnostic_record");
        if (diagnosticRecordValue != null && TypeSystem.getDefault().MAP().isTypeOf(diagnosticRecordValue)) {
            boolean containsOperation = diagnosticRecordValue.containsKey("OPERATION");
            boolean containsOperationCode = diagnosticRecordValue.containsKey("OPERATION_CODE");
            boolean containsCurrentSchema = diagnosticRecordValue.containsKey("CURRENT_SCHEMA");
            if (containsOperation && containsOperationCode && containsCurrentSchema) {
                diagnosticRecord = diagnosticRecordValue.asMap(Values::value);
            } else {
                diagnosticRecord = new HashMap<String, Value>(diagnosticRecordValue.asMap(Values::value));
                if (!containsOperation) {
                    diagnosticRecord.put("OPERATION", Values.value(""));
                }
                if (!containsOperationCode) {
                    diagnosticRecord.put("OPERATION_CODE", Values.value("0"));
                }
                if (!containsCurrentSchema) {
                    diagnosticRecord.put("CURRENT_SCHEMA", Values.value("/"));
                }
                diagnosticRecord = Collections.unmodifiableMap(diagnosticRecord);
            }
        } else {
            diagnosticRecord = Map.ofEntries(Map.entry("OPERATION", Values.value("")), Map.entry("OPERATION_CODE", Values.value("0")), Map.entry("CURRENT_SCHEMA", Values.value("/")));
        }
        String neo4jCode = value.get("neo4j_code").asString(null);
        if (neo4jCode == null || neo4jCode.trim().isEmpty()) {
            InternalGqlStatusObject gqlStatusObject = new InternalGqlStatusObject(status, description, diagnosticRecord);
            return new GqlStatusObjectAndNotification(gqlStatusObject, null);
        }
        String title = value.get("title").asString();
        String notificationDescription = value.containsKey("description") ? value.get("description").asString() : description;
        Value positionValue = (Value)diagnosticRecord.get("_position");
        InternalInputPosition position = null;
        if (positionValue != null && TypeSystem.getDefault().MAP().isTypeOf(positionValue) && Stream.of(offset = MetadataExtractor.getAsInt(positionValue, "offset"), line = MetadataExtractor.getAsInt(positionValue, "line"), column = MetadataExtractor.getAsInt(positionValue, "column")).allMatch(OptionalInt::isPresent)) {
            position = new InternalInputPosition(offset.getAsInt(), line.getAsInt(), column.getAsInt());
        }
        Value severityValue = (Value)diagnosticRecord.get("_severity");
        String rawSeverity = null;
        if (severityValue != null && TypeSystem.getDefault().STRING().isTypeOf(severityValue)) {
            rawSeverity = severityValue.asString();
        }
        NotificationSeverity severity = InternalNotificationSeverity.valueOf(rawSeverity).orElse(null);
        Value classificationValue = (Value)diagnosticRecord.get("_classification");
        String rawClassification = null;
        if (classificationValue != null && TypeSystem.getDefault().STRING().isTypeOf(classificationValue)) {
            rawClassification = classificationValue.asString();
        }
        NotificationClassification classification = InternalNotification.valueOf(rawClassification).orElse(null);
        InternalGqlNotification gqlNotification = new InternalGqlNotification(status, description, diagnosticRecord, position, severity, rawSeverity, classification, rawClassification);
        InternalNotification notification = new InternalNotification(neo4jCode, title, notificationDescription, severity, rawSeverity, classification, rawClassification, position);
        return new GqlStatusObjectAndNotification(gqlNotification, notification);
    }

    private static OptionalInt getAsInt(MapAccessor mapAccessor, String key) {
        Value value = mapAccessor.get(key);
        if (value != null && TypeSystem.getDefault().INTEGER().isTypeOf(value)) {
            return OptionalInt.of(value.asInt());
        }
        return OptionalInt.empty();
    }

    private static long extractResultConsumedAfter(Map<String, Value> metadata, String key) {
        Value resultConsumedAfterValue = metadata.get(key);
        if (resultConsumedAfterValue != null) {
            return resultConsumedAfterValue.asLong();
        }
        return -1L;
    }

    private record GqlStatusObjectsAndNotifications(Set<GqlStatusObject> gqlStatusObjects, List<Notification> notifications) {
    }

    private record GqlStatusObjectAndNotification(GqlStatusObject gqlStatusObject, Notification notification) {
    }
}

