/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.net.SocketAddress;
import java.net.URI;
import java.time.Clock;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltConnectionParameters;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltConnectionProviderFactory;
import org.neo4j.bolt.connection.BoltConnectionSource;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DefaultDomainNameResolver;
import org.neo4j.bolt.connection.DomainNameResolver;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.MetricsListener;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.RoutedBoltConnectionParameters;
import org.neo4j.bolt.connection.pooled.PooledBoltConnectionSource;
import org.neo4j.bolt.connection.pooled.SecurityPlanSupplier;
import org.neo4j.bolt.connection.routed.BoltConnectionSourceFactory;
import org.neo4j.bolt.connection.routed.Rediscovery;
import org.neo4j.bolt.connection.routed.RoutedBoltConnectionSource;
import org.neo4j.bolt.connection.values.ValueFactory;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.ClientCertificateManager;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.MetricsAdapter;
import org.neo4j.driver.exceptions.AuthTokenManagerExecutionException;
import org.neo4j.driver.internal.BoltLoggingProvider;
import org.neo4j.driver.internal.IdentityResolver;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.NotificationConfigMapper;
import org.neo4j.driver.internal.Scheme;
import org.neo4j.driver.internal.SecuritySettings;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionFactoryImpl;
import org.neo4j.driver.internal.adaptedbolt.AdaptingDriverBoltConnectionSource;
import org.neo4j.driver.internal.adaptedbolt.BoltAuthTokenManager;
import org.neo4j.driver.internal.adaptedbolt.BoltConnectionProviderFactoryLoader;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnectionSource;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;
import org.neo4j.driver.internal.adaptedbolt.SingleRoutedBoltConnectionSource;
import org.neo4j.driver.internal.boltlistener.BoltConnectionListener;
import org.neo4j.driver.internal.homedb.HomeDatabaseCache;
import org.neo4j.driver.internal.metrics.DevNullMetricsProvider;
import org.neo4j.driver.internal.metrics.InternalMetricsProvider;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.metrics.MicrometerMetricsProvider;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.security.BoltSecurityPlanManager;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.SecurityPlans;
import org.neo4j.driver.internal.util.DriverInfoUtil;
import org.neo4j.driver.internal.value.BoltValueFactory;
import org.neo4j.driver.net.ServerAddress;
import org.neo4j.driver.net.ServerAddressResolver;

public class DriverFactory {
    public static final String NO_ROUTING_CONTEXT_ERROR_MESSAGE = "Routing parameters are not supported with scheme 'bolt'. Given URI: ";

    public final Driver newInstance(URI uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager, Config config) {
        return this.newInstance(uri, authTokenManager, clientCertificateManager, config, null, null, null);
    }

    public final Driver newInstance(URI uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager, Config config, SecurityPlan securityPlan, ScheduledExecutorService eventLoopGroup, Supplier<Rediscovery> rediscoverySupplier) {
        BoltConnectionProviderFactoryLoader boltConnectionProviderFactoryLoader = new BoltConnectionProviderFactoryLoader(config.logging(), uri);
        BoltConnectionProviderFactory boltConnectionProviderFactory = boltConnectionProviderFactoryLoader.providerFactory().orElseThrow(() -> new IllegalArgumentException("Unsupported scheme: " + boltConnectionProviderFactoryLoader.scheme()));
        if (securityPlan == null) {
            SecuritySettings settings = new SecuritySettings(config.encrypted(), config.trustStrategy());
            securityPlan = SecurityPlans.createSecurityPlan(settings, uri.getScheme(), clientCertificateManager, config.logging());
        }
        BoltSecurityPlanManager securityPlanManager = BoltSecurityPlanManager.from(securityPlan);
        return this.newInstance(uri, authTokenManager, config, securityPlanManager, eventLoopGroup, rediscoverySupplier, boltConnectionProviderFactory);
    }

    public final Driver newInstance(URI uri, AuthTokenManager authTokenManager, Config config, BoltSecurityPlanManager securityPlanManager, ScheduledExecutorService eventLoopGroup, Supplier<Rediscovery> rediscoverySupplier, BoltConnectionProviderFactory boltConnectionProviderFactory) {
        Objects.requireNonNull(authTokenManager, "authTokenProvider must not be null");
        ScheduledExecutorService retryExecutor = eventLoopGroup != null ? eventLoopGroup : Executors.newSingleThreadScheduledExecutor();
        RetryLogic retryLogic = this.createRetryLogic(config.maxTransactionRetryTimeMillis(), retryExecutor, config.logging());
        MetricsProvider metricsProvider = DriverFactory.getOrCreateMetricsProvider(config, this.createClock());
        return this.createDriver(uri, securityPlanManager, eventLoopGroup, retryLogic, metricsProvider, config, authTokenManager, rediscoverySupplier, boltConnectionProviderFactory);
    }

    protected static MetricsProvider getOrCreateMetricsProvider(Config config, Clock clock) {
        MetricsAdapter metricsAdapter = config.metricsAdapter();
        if (metricsAdapter == null) {
            metricsAdapter = config.isMetricsEnabled() ? MetricsAdapter.DEFAULT : MetricsAdapter.DEV_NULL;
        }
        return switch (metricsAdapter) {
            default -> throw new IncompatibleClassChangeError();
            case MetricsAdapter.DEV_NULL -> DevNullMetricsProvider.INSTANCE;
            case MetricsAdapter.DEFAULT -> new InternalMetricsProvider(clock, config.logging());
            case MetricsAdapter.MICROMETER -> MicrometerMetricsProvider.forGlobalRegistry();
        };
    }

    private InternalDriver createDriver(URI uri, BoltSecurityPlanManager securityPlanManager, ScheduledExecutorService eventLoopGroup, RetryLogic retryLogic, MetricsProvider metricsProvider, Config config, AuthTokenManager authTokenManager, Supplier<Rediscovery> rediscoverySupplier, BoltConnectionProviderFactory boltConnectionProviderFactory) {
        DriverBoltConnectionSource boltConnectionProvider = null;
        try {
            HomeDatabaseCache homeDatabaseCache = HomeDatabaseCache.newInstance(Scheme.isRoutingScheme(uri.getScheme()));
            BoltValueFactory valueFactory = BoltValueFactory.getInstance();
            boltConnectionProvider = this.createDriverBoltConnectionProvider(uri, config, eventLoopGroup, rediscoverySupplier, homeDatabaseCache, DriverInfoUtil.boltAgent(), config.userAgent(), config.connectionTimeoutMillis(), metricsProvider.metricsListener(), authTokenManager, securityPlanManager::plan, NotificationConfigMapper.map(config.notificationConfig()), boltConnectionProviderFactory);
            SessionFactory sessionFactory = this.createSessionFactory(securityPlanManager, boltConnectionProvider, retryLogic, config, authTokenManager, homeDatabaseCache);
            InternalDriver driver = this.createDriver(securityPlanManager, sessionFactory, metricsProvider, config);
            Logger log = config.logging().getLog(this.getClass());
            log.info("Driver instance %s created for server uri '%s'", driver.hashCode(), uri);
            return driver;
        }
        catch (Throwable driverError) {
            if (boltConnectionProvider != null) {
                boltConnectionProvider.close().toCompletableFuture().join();
            }
            throw driverError;
        }
    }

    private Function<BoltServerAddress, Set<BoltServerAddress>> createBoltServerAddressResolver(Config config) {
        ServerAddressResolver serverAddressResolver = config.resolver() != null ? config.resolver() : IdentityResolver.IDENTITY_RESOLVER;
        return boltAddress -> serverAddressResolver.resolve(ServerAddress.of(boltAddress.host(), boltAddress.port())).stream().map(serverAddress -> new BoltServerAddress(serverAddress.host(), serverAddress.port())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private DriverBoltConnectionSource createDriverBoltConnectionProvider(URI uri, Config config, ScheduledExecutorService eventLoopGroup, Supplier<Rediscovery> rediscoverySupplier, BoltConnectionListener boltConnectionListener, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener, AuthTokenManager authTokenManager, SecurityPlanSupplier securityPlanSupplier, NotificationConfig notificationConfig, BoltConnectionProviderFactory boltConnectionProviderFactory) {
        Clock clock = this.createClock();
        BoltValueFactory boltValueFactory = BoltValueFactory.getInstance();
        ErrorMapper errorMapper = ErrorMapper.getInstance();
        BoltAuthTokenManager boltAuthTokenManager = new BoltAuthTokenManager(authTokenManager, boltValueFactory, errorMapper);
        BoltConnectionSource<RoutedBoltConnectionParameters> boltConnectionProvider = this.createBoltConnectionSource(uri, config, eventLoopGroup, rediscoverySupplier, boltConnectionListener, boltAgent, userAgent, connectTimeoutMillis, metricsListener, clock, boltAuthTokenManager, securityPlanSupplier, notificationConfig, boltConnectionProviderFactory);
        return new AdaptingDriverBoltConnectionSource(boltConnectionProvider, errorMapper, boltValueFactory, Scheme.isRoutingScheme(uri.getScheme()));
    }

    protected BoltConnectionSource<RoutedBoltConnectionParameters> createBoltConnectionSource(URI uri, Config config, ScheduledExecutorService eventLoopGroup, Supplier<Rediscovery> rediscoverySupplier, BoltConnectionListener boltConnectionListener, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener, Clock clock, org.neo4j.bolt.connection.pooled.AuthTokenManager authTokenManager, SecurityPlanSupplier securityPlanSupplier, NotificationConfig notificationConfig, BoltConnectionProviderFactory boltConnectionProviderFactory) {
        BoltLoggingProvider loggingProvider = new BoltLoggingProvider(config.logging());
        switch (uri.getScheme()) {
            case "bolt": 
            case "bolt+ssc": 
            case "bolt+s": {
                if (uri.getQuery() == null || uri.getQuery().isEmpty()) break;
                throw new IllegalArgumentException("Routing parameters are not supported with scheme 'bolt'. Given URI: '" + String.valueOf(uri) + "'");
            }
        }
        String routingContextAddress = "%s:%d".formatted(uri.getHost(), uri.getPort() != -1 ? uri.getPort() : 7687);
        BoltConnectionSourceFactory pooledSourceSupplierFactory = this.createPooledBoltConnectionSource(config, eventLoopGroup, clock, loggingProvider, boltConnectionListener, routingContextAddress, boltAgent, userAgent, connectTimeoutMillis, metricsListener, authTokenManager, securityPlanSupplier, notificationConfig, boltConnectionProviderFactory);
        SingleRoutedBoltConnectionSource boltConnectionSource = Scheme.isRoutingScheme(uri.getScheme()) ? this.createRoutedBoltConnectionProvider(config, pooledSourceSupplierFactory, config.routingTablePurgeDelayMillis(), rediscoverySupplier, clock, loggingProvider, uri, boltAgent, userAgent, connectTimeoutMillis, metricsListener) : new SingleRoutedBoltConnectionSource((BoltConnectionSource<BoltConnectionParameters>)pooledSourceSupplierFactory.create(uri, null));
        return boltConnectionSource;
    }

    private RoutedBoltConnectionSource createRoutedBoltConnectionProvider(Config config, BoltConnectionSourceFactory boltConnectionSourceFactory, long routingTablePurgeDelayMs, Supplier<Rediscovery> rediscoverySupplier, Clock clock, LoggingProvider loggingProvider, URI uri, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener) {
        Function<BoltServerAddress, Set<BoltServerAddress>> boltServerAddressResolver = this.createBoltServerAddressResolver(config);
        Rediscovery rediscovery = rediscoverySupplier != null ? rediscoverySupplier.get() : null;
        return new RoutedBoltConnectionSource(boltConnectionSourceFactory, boltServerAddressResolver, this.getDomainNameResolver(), routingTablePurgeDelayMs, rediscovery, clock, loggingProvider, uri, List.of(AuthTokenManagerExecutionException.class));
    }

    private BoltConnectionSourceFactory createPooledBoltConnectionSource(Config config, ScheduledExecutorService eventLoopGroup, Clock clock, LoggingProvider loggingProvider, BoltConnectionListener boltConnectionListener, String routingContextAddress, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, MetricsListener metricsListener, org.neo4j.bolt.connection.pooled.AuthTokenManager authTokenManager, SecurityPlanSupplier securityPlanSupplier, NotificationConfig notificationConfig, BoltConnectionProviderFactory boltConnectionProviderFactory) {
        return (uri, expectedVerificationHostname) -> {
            BoltConnectionProvider boltConnectionProvider = this.createBoltConnectionProvider(uri, eventLoopGroup, clock, loggingProvider, config.eventLoopThreads(), boltConnectionProviderFactory);
            BoltConnectionProvider listeningBoltConnectionProvider = BoltConnectionListener.listeningBoltConnectionProvider(boltConnectionProvider, boltConnectionListener);
            return new PooledBoltConnectionSource(loggingProvider, clock, uri, listeningBoltConnectionProvider, authTokenManager, DriverFactory.createSecurityPlanSupplierWithHostname(securityPlanSupplier, expectedVerificationHostname), config.maxConnectionPoolSize(), config.connectionAcquisitionTimeoutMillis(), config.maxConnectionLifetimeMillis(), config.idleTimeBeforeConnectionTest(), metricsListener, routingContextAddress, boltAgent, userAgent, connectTimeoutMillis, notificationConfig);
        };
    }

    private BoltConnectionProvider createBoltConnectionProvider(URI uri, ScheduledExecutorService eventLoopGroup, Clock clock, LoggingProvider loggingProvider, int eventLoopThreads, BoltConnectionProviderFactory boltConnectionProviderFactory) {
        HashMap<String, Object> additionalConfig = new HashMap<String, Object>();
        additionalConfig.put("clock", clock);
        if (eventLoopGroup != null) {
            additionalConfig.put("eventLoopGroup", eventLoopGroup);
        } else if (eventLoopThreads > 0) {
            additionalConfig.put("eventLoopThreads", eventLoopThreads);
        }
        SocketAddress localAddress = this.localAddress();
        if (localAddress != null) {
            additionalConfig.put("localAddress", localAddress);
        }
        return boltConnectionProviderFactory.create(loggingProvider, (ValueFactory)BoltValueFactory.getInstance(), null, additionalConfig);
    }

    protected SocketAddress localAddress() {
        return null;
    }

    protected InternalDriver createDriver(BoltSecurityPlanManager securityPlanManager, SessionFactory sessionFactory, MetricsProvider metricsProvider, Config config) {
        return new InternalDriver(securityPlanManager, sessionFactory, metricsProvider, config.isTelemetryDisabled(), config.logging());
    }

    protected Clock createClock() {
        return Clock.systemUTC();
    }

    protected SessionFactory createSessionFactory(BoltSecurityPlanManager securityPlanManager, DriverBoltConnectionSource connectionProvider, RetryLogic retryLogic, Config config, AuthTokenManager authTokenManager, HomeDatabaseCache homeDatabaseCache) {
        return new SessionFactoryImpl(securityPlanManager, connectionProvider, retryLogic, config, authTokenManager, homeDatabaseCache);
    }

    protected RetryLogic createRetryLogic(long maxTransactionRetryTime, ScheduledExecutorService executor, Logging logging) {
        return new ExponentialBackoffRetryLogic(maxTransactionRetryTime, executor, this.createClock(), logging);
    }

    protected DomainNameResolver getDomainNameResolver() {
        return DefaultDomainNameResolver.getInstance();
    }

    private static SecurityPlanSupplier createSecurityPlanSupplierWithHostname(SecurityPlanSupplier securityPlanSupplier, String expectedVerificationHostname) {
        return expectedVerificationHostname != null ? () -> securityPlanSupplier.getPlan().thenApply(securityPlan -> {
            if (securityPlan != null && securityPlan.expectedHostname() == null) {
                return org.neo4j.bolt.connection.SecurityPlans.encrypted((SSLContext)securityPlan.sslContext(), (boolean)securityPlan.verifyHostname(), (String)expectedVerificationHostname);
            }
            return securityPlan;
        }) : securityPlanSupplier;
    }
}

