/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import java.io.IOException;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageEncoder;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.request.RouteMessage;
import org.neo4j.driver.internal.util.Preconditions;

public class RouteMessageEncoder
implements MessageEncoder {
    @Override
    public void encode(Message message, ValuePacker packer) throws IOException {
        Preconditions.checkArgument(message, RouteMessage.class);
        RouteMessage routeMessage = (RouteMessage)message;
        packer.packStructHeader(3, message.signature());
        packer.pack(routeMessage.getRoutingContext());
        packer.pack(Values.value(routeMessage.getBookmarks().stream().map(Bookmark::value)));
        packer.pack(routeMessage.getDatabaseName());
    }
}

