/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v52;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.util.Collections;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.handlers.HelloResponseHandler;
import org.neo4j.driver.internal.handlers.LogonResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.messaging.request.LogonMessage;
import org.neo4j.driver.internal.messaging.v51.BoltProtocolV51;
import org.neo4j.driver.internal.security.InternalAuthToken;

public class BoltProtocolV52
extends BoltProtocolV51 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(5, 2);
    public static final BoltProtocol INSTANCE = new BoltProtocolV52();

    @Override
    public void initializeChannel(String userAgent, AuthToken authToken, RoutingContext routingContext, ChannelPromise channelInitializedPromise, NotificationConfig notificationConfig) {
        Channel channel = channelInitializedPromise.channel();
        HelloMessage message = routingContext.isServerRoutingEnabled() ? new HelloMessage(userAgent, Collections.emptyMap(), routingContext.toMap(), false, notificationConfig) : new HelloMessage(userAgent, Collections.emptyMap(), null, false, notificationConfig);
        ChannelAttributes.messageDispatcher(channel).enqueue(new HelloResponseHandler(channel.voidPromise()));
        ChannelAttributes.messageDispatcher(channel).enqueue(new LogonResponseHandler(channelInitializedPromise));
        channel.write((Object)message, channel.voidPromise());
        channel.writeAndFlush((Object)new LogonMessage(((InternalAuthToken)authToken).toMap()));
    }

    @Override
    protected Neo4jException verifyNotificationConfigSupported(NotificationConfig notificationConfig) {
        return null;
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }
}

