/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.logging.JULogger;

public class ConsoleLogging
implements Logging,
Serializable {
    private static final long serialVersionUID = 9205935204074879150L;
    private final Level level;

    public ConsoleLogging(Level level) {
        this.level = Objects.requireNonNull(level);
    }

    @Override
    public Logger getLog(String name) {
        return new ConsoleLogger(name, this.level);
    }

    public static class ConsoleLogger
    extends JULogger {
        private final ConsoleHandler handler;

        public ConsoleLogger(String name, Level level) {
            super(name, level);
            Handler[] handlers;
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger(name);
            logger.setUseParentHandlers(false);
            for (Handler handlerToRemove : handlers = logger.getHandlers()) {
                logger.removeHandler(handlerToRemove);
            }
            this.handler = new ConsoleHandler();
            this.handler.setFormatter(new ConsoleFormatter());
            this.handler.setLevel(level);
            logger.addHandler(this.handler);
            logger.setLevel(level);
        }
    }

    private static class ConsoleFormatter
    extends Formatter {
        private ConsoleFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + " " + record.getLevel() + " " + record.getLoggerName() + " - " + this.formatMessage(record) + this.formatThrowable(record.getThrown()) + "\n";
        }

        private String formatThrowable(Throwable throwable) {
            String throwableString = "";
            if (throwable != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                throwable.printStackTrace(pw);
                pw.close();
                throwableString = sw.toString();
            }
            return throwableString;
        }
    }
}

