/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.internal.async.connection.AuthorizationStateListener;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.handlers.PingResponseHandler;
import org.neo4j.driver.internal.messaging.request.ResetMessage;

public class NettyChannelHealthChecker
implements ChannelHealthChecker,
AuthorizationStateListener {
    private final PoolSettings poolSettings;
    private final Clock clock;
    private final Logging logging;
    private final Logger log;
    private final AtomicReference<Optional<Long>> minCreationTimestampMillisOpt;

    public NettyChannelHealthChecker(PoolSettings poolSettings, Clock clock, Logging logging) {
        this.poolSettings = poolSettings;
        this.clock = clock;
        this.logging = logging;
        this.log = logging.getLog(this.getClass());
        this.minCreationTimestampMillisOpt = new AtomicReference(Optional.empty());
    }

    public Future<Boolean> isHealthy(Channel channel) {
        if (this.isTooOld(channel)) {
            return channel.eventLoop().newSucceededFuture((Object)Boolean.FALSE);
        }
        if (this.hasBeenIdleForTooLong(channel)) {
            return this.ping(channel);
        }
        return ACTIVE.isHealthy(channel);
    }

    @Override
    public void onExpired(AuthorizationExpiredException e, Channel channel) {
        long ts = ChannelAttributes.creationTimestamp(channel);
        this.minCreationTimestampMillisOpt.getAndUpdate(prev -> Optional.of(prev.filter(prevTs -> ts <= prevTs).orElse(ts)));
    }

    private boolean isTooOld(Channel channel) {
        long creationTimestampMillis = ChannelAttributes.creationTimestamp(channel);
        Optional<Long> minCreationTimestampMillisOpt = this.minCreationTimestampMillisOpt.get();
        if (minCreationTimestampMillisOpt.isPresent() && creationTimestampMillis <= minCreationTimestampMillisOpt.get()) {
            this.log.trace("The channel %s is marked for closure as its creation timestamp is older than or equal to the acceptable minimum timestamp: %s <= %s", channel, creationTimestampMillis, minCreationTimestampMillisOpt.get());
            return true;
        }
        if (this.poolSettings.maxConnectionLifetimeEnabled()) {
            long maxAgeMillis;
            boolean tooOld;
            long currentTimestampMillis = this.clock.millis();
            long ageMillis = currentTimestampMillis - creationTimestampMillis;
            boolean bl = tooOld = ageMillis > (maxAgeMillis = this.poolSettings.maxConnectionLifetime());
            if (tooOld) {
                this.log.trace("Failed acquire channel %s from the pool because it is too old: %s > %s", channel, ageMillis, maxAgeMillis);
            }
            return tooOld;
        }
        return false;
    }

    private boolean hasBeenIdleForTooLong(Channel channel) {
        Long lastUsedTimestamp;
        if (this.poolSettings.idleTimeBeforeConnectionTestEnabled() && (lastUsedTimestamp = ChannelAttributes.lastUsedTimestamp(channel)) != null) {
            boolean idleTooLong;
            long idleTime = this.clock.millis() - lastUsedTimestamp;
            boolean bl = idleTooLong = idleTime > this.poolSettings.idleTimeBeforeConnectionTest();
            if (idleTooLong) {
                this.log.trace("Channel %s has been idle for %s and needs a ping", channel, idleTime);
            }
            return idleTooLong;
        }
        return false;
    }

    private Future<Boolean> ping(Channel channel) {
        Promise result = channel.eventLoop().newPromise();
        ChannelAttributes.messageDispatcher(channel).enqueue(new PingResponseHandler((Promise<Boolean>)result, channel, this.logging));
        channel.writeAndFlush((Object)ResetMessage.RESET, channel.voidPromise());
        return result;
    }
}

