/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.pooledimpl.impl;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.AuthInfo;
import org.neo4j.driver.internal.bolt.api.AuthToken;
import org.neo4j.driver.internal.bolt.api.BasicResponseHandler;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltConnectionState;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.ResponseHandler;
import org.neo4j.driver.internal.bolt.api.TelemetryApi;
import org.neo4j.driver.internal.bolt.api.TransactionType;
import org.neo4j.driver.internal.bolt.api.exception.BoltFailureException;
import org.neo4j.driver.internal.bolt.api.summary.BeginSummary;
import org.neo4j.driver.internal.bolt.api.summary.CommitSummary;
import org.neo4j.driver.internal.bolt.api.summary.DiscardSummary;
import org.neo4j.driver.internal.bolt.api.summary.LogoffSummary;
import org.neo4j.driver.internal.bolt.api.summary.LogonSummary;
import org.neo4j.driver.internal.bolt.api.summary.PullSummary;
import org.neo4j.driver.internal.bolt.api.summary.ResetSummary;
import org.neo4j.driver.internal.bolt.api.summary.RollbackSummary;
import org.neo4j.driver.internal.bolt.api.summary.RouteSummary;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.bolt.api.summary.TelemetrySummary;
import org.neo4j.driver.internal.bolt.api.values.Value;
import org.neo4j.driver.internal.bolt.pooledimpl.PooledBoltConnectionProvider;

public class PooledBoltConnection
implements BoltConnection {
    private final BoltConnection delegate;
    private final PooledBoltConnectionProvider provider;
    private final Runnable releaseRunnable;
    private final Runnable purgeRunnable;
    private CompletableFuture<Void> closeFuture;

    public PooledBoltConnection(BoltConnection delegate, PooledBoltConnectionProvider provider, Runnable releaseRunnable, Runnable purgeRunnable) {
        this.delegate = Objects.requireNonNull(delegate);
        this.provider = Objects.requireNonNull(provider);
        this.releaseRunnable = Objects.requireNonNull(releaseRunnable);
        this.purgeRunnable = Objects.requireNonNull(purgeRunnable);
    }

    @Override
    public CompletionStage<BoltConnection> onLoop() {
        return this.delegate.onLoop();
    }

    @Override
    public CompletionStage<BoltConnection> route(DatabaseName databaseName, String impersonatedUser, Set<String> bookmarks) {
        return this.delegate.route(databaseName, impersonatedUser, bookmarks).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> beginTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, String txType, NotificationConfig notificationConfig) {
        return this.delegate.beginTransaction(databaseName, accessMode, impersonatedUser, bookmarks, transactionType, txTimeout, txMetadata, txType, notificationConfig).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> runInAutoCommitTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        return this.delegate.runInAutoCommitTransaction(databaseName, accessMode, impersonatedUser, bookmarks, query, parameters, txTimeout, txMetadata, notificationConfig).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> run(String query, Map<String, Value> parameters) {
        return this.delegate.run(query, parameters).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> pull(long qid, long request) {
        return this.delegate.pull(qid, request).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> discard(long qid, long number) {
        return this.delegate.discard(qid, number).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> commit() {
        return this.delegate.commit().thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> rollback() {
        return this.delegate.rollback().thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> reset() {
        return this.delegate.reset().thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> logoff() {
        return this.delegate.logoff().thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> logon(AuthToken authToken) {
        return this.delegate.logon(authToken).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> telemetry(TelemetryApi telemetryApi) {
        return this.delegate.telemetry(telemetryApi).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> clear() {
        return this.delegate.clear();
    }

    @Override
    public CompletionStage<Void> flush(final ResponseHandler handler) {
        return this.delegate.flush(new ResponseHandler(){

            @Override
            public void onError(Throwable throwable) {
                BoltFailureException boltFailureException;
                if (throwable instanceof BoltFailureException && "Neo.ClientError.Security.AuthorizationExpired".equals((boltFailureException = (BoltFailureException)throwable).code())) {
                    PooledBoltConnection.this.provider.onExpired();
                }
                handler.onError(throwable);
            }

            @Override
            public void onBeginSummary(BeginSummary summary) {
                handler.onBeginSummary(summary);
            }

            @Override
            public void onRunSummary(RunSummary summary) {
                handler.onRunSummary(summary);
            }

            @Override
            public void onRecord(Value[] fields) {
                handler.onRecord(fields);
            }

            @Override
            public void onPullSummary(PullSummary summary) {
                handler.onPullSummary(summary);
            }

            @Override
            public void onDiscardSummary(DiscardSummary summary) {
                handler.onDiscardSummary(summary);
            }

            @Override
            public void onCommitSummary(CommitSummary summary) {
                handler.onCommitSummary(summary);
            }

            @Override
            public void onRollbackSummary(RollbackSummary summary) {
                handler.onRollbackSummary(summary);
            }

            @Override
            public void onResetSummary(ResetSummary summary) {
                handler.onResetSummary(summary);
            }

            @Override
            public void onRouteSummary(RouteSummary summary) {
                handler.onRouteSummary(summary);
            }

            @Override
            public void onLogoffSummary(LogoffSummary summary) {
                handler.onLogoffSummary(summary);
            }

            @Override
            public void onLogonSummary(LogonSummary summary) {
                handler.onLogonSummary(summary);
            }

            @Override
            public void onTelemetrySummary(TelemetrySummary summary) {
                handler.onTelemetrySummary(summary);
            }

            @Override
            public void onIgnored() {
                handler.onIgnored();
            }

            @Override
            public void onComplete() {
                handler.onComplete();
            }
        }).whenComplete((ignored, throwable) -> {
            if (throwable != null && this.delegate.state() == BoltConnectionState.CLOSED) {
                this.purgeRunnable.run();
            }
        });
    }

    @Override
    public CompletionStage<Void> forceClose(String reason) {
        return this.delegate.forceClose(reason).whenComplete((closeResult, closeThrowable) -> this.purgeRunnable.run());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture;
        boolean close = false;
        PooledBoltConnection pooledBoltConnection = this;
        synchronized (pooledBoltConnection) {
            if (this.closeFuture == null) {
                this.closeFuture = new CompletableFuture();
                close = true;
            }
            closeFuture = this.closeFuture;
        }
        if (close) {
            if (this.delegate.state() == BoltConnectionState.CLOSED) {
                this.purgeRunnable.run();
                closeFuture.complete(null);
                return closeFuture;
            }
            if (this.delegate.state() == BoltConnectionState.ERROR) {
                this.purgeRunnable.run();
                closeFuture.complete(null);
                return closeFuture;
            }
            BasicResponseHandler resetHandler = new BasicResponseHandler();
            this.delegate.reset().thenCompose(boltConnection -> boltConnection.flush(resetHandler)).thenCompose(ignored -> resetHandler.summaries()).whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    this.delegate.close().whenComplete((closeResult, closeThrowable) -> this.purgeRunnable.run());
                } else {
                    CompletableFuture.completedStage(null).whenComplete((ignoredResult, nothing) -> this.releaseRunnable.run());
                }
                closeFuture.complete(null);
            });
        }
        return closeFuture;
    }

    @Override
    public CompletionStage<Void> setReadTimeout(Duration duration) {
        return this.delegate.setReadTimeout(duration);
    }

    @Override
    public BoltConnectionState state() {
        return this.delegate.state();
    }

    @Override
    public CompletionStage<AuthInfo> authInfo() {
        return this.delegate.authInfo();
    }

    @Override
    public String serverAgent() {
        return this.delegate.serverAgent();
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    @Override
    public BoltProtocolVersion protocolVersion() {
        return this.delegate.protocolVersion();
    }

    @Override
    public boolean telemetrySupported() {
        return this.delegate.telemetrySupported();
    }

    @Override
    public boolean serverSideRoutingEnabled() {
        return this.delegate.serverSideRoutingEnabled();
    }

    @Override
    public Optional<Duration> defaultReadTimeout() {
        return this.delegate.defaultReadTimeout();
    }

    public BoltConnection delegate() {
        return this.delegate;
    }
}

