/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.bolt.api.AuthToken;
import org.neo4j.driver.internal.bolt.api.AuthTokenImpl;
import org.neo4j.driver.internal.bolt.api.values.Value;
import org.neo4j.driver.internal.bolt.api.values.ValueFactory;

public final class AuthTokens {
    private static final String SCHEME_KEY = "scheme";
    private static final String PRINCIPAL_KEY = "principal";
    private static final String CREDENTIALS_KEY = "credentials";
    private static final String REALM_KEY = "realm";
    private static final String PARAMETERS_KEY = "parameters";

    private AuthTokens() {
    }

    public static AuthToken basic(String username, String password, String realm, ValueFactory valueFactory) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        Objects.requireNonNull(valueFactory);
        HashMap<String, Value> map = new HashMap<String, Value>(4);
        map.put(SCHEME_KEY, valueFactory.value("basic"));
        map.put(PRINCIPAL_KEY, valueFactory.value(username));
        map.put(CREDENTIALS_KEY, valueFactory.value(password));
        if (realm != null) {
            map.put(REALM_KEY, valueFactory.value(realm));
        }
        return new AuthTokenImpl(Collections.unmodifiableMap(map));
    }

    public static AuthToken bearer(String token, ValueFactory valueFactory) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(valueFactory);
        HashMap<String, Value> map = new HashMap<String, Value>(2);
        map.put(SCHEME_KEY, valueFactory.value("bearer"));
        map.put(CREDENTIALS_KEY, valueFactory.value(token));
        return new AuthTokenImpl(Collections.unmodifiableMap(map));
    }

    public static AuthToken kerberos(String base64EncodedTicket, ValueFactory valueFactory) {
        Objects.requireNonNull(base64EncodedTicket);
        Objects.requireNonNull(valueFactory);
        HashMap<String, Value> map = new HashMap<String, Value>(3);
        map.put(SCHEME_KEY, valueFactory.value("kerberos"));
        map.put(PRINCIPAL_KEY, valueFactory.value(""));
        map.put(CREDENTIALS_KEY, valueFactory.value(base64EncodedTicket));
        return new AuthTokenImpl(Collections.unmodifiableMap(map));
    }

    public static AuthToken none(ValueFactory valueFactory) {
        Objects.requireNonNull(valueFactory);
        return new AuthTokenImpl(Collections.singletonMap(SCHEME_KEY, valueFactory.value("none")));
    }

    public static AuthToken custom(Map<String, Value> map) {
        Objects.requireNonNull(map);
        return new AuthTokenImpl(Collections.unmodifiableMap(map));
    }
}

