/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.time.Clock;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenAndExpiration;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.TokenExpiredException;
import org.neo4j.driver.internal.security.ExpirationBasedAuthTokenManager;

public final class AuthTokenManagers {
    private AuthTokenManagers() {
    }

    public static AuthTokenManager basic(Supplier<AuthToken> newTokenSupplier) {
        Objects.requireNonNull(newTokenSupplier, "newTokenSupplier must not be null");
        return AuthTokenManagers.basicAsync(() -> CompletableFuture.supplyAsync(newTokenSupplier));
    }

    public static AuthTokenManager basicAsync(Supplier<CompletionStage<AuthToken>> newTokenStageSupplier) {
        Objects.requireNonNull(newTokenStageSupplier, "newTokenStageSupplier must not be null");
        return new ExpirationBasedAuthTokenManager(() -> ((CompletionStage)newTokenStageSupplier.get()).thenApply(authToken -> authToken.expiringAt(Long.MAX_VALUE)), Set.of(AuthenticationException.class), Clock.systemUTC());
    }

    public static AuthTokenManager bearer(Supplier<AuthTokenAndExpiration> newTokenSupplier) {
        Objects.requireNonNull(newTokenSupplier, "newTokenSupplier must not be null");
        return AuthTokenManagers.bearerAsync(() -> CompletableFuture.supplyAsync(newTokenSupplier));
    }

    public static AuthTokenManager bearerAsync(Supplier<CompletionStage<AuthTokenAndExpiration>> newTokenStageSupplier) {
        Objects.requireNonNull(newTokenStageSupplier, "newTokenStageSupplier must not be null");
        return new ExpirationBasedAuthTokenManager(newTokenStageSupplier, Set.of(TokenExpiredException.class, AuthenticationException.class), Clock.systemUTC());
    }
}

