/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.boltlistener;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.AuthToken;
import org.neo4j.driver.internal.bolt.api.BoltAgent;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.boltlistener.BoltConnectionListener;
import org.neo4j.driver.internal.boltlistener.ListeningBoltConnection;

final class ListeningBoltConnectionProvider
implements BoltConnectionProvider {
    private final BoltConnectionProvider delegate;
    private final BoltConnectionListener boltConnectionListener;

    public ListeningBoltConnectionProvider(BoltConnectionProvider delegate, BoltConnectionListener boltConnectionListener) {
        this.delegate = Objects.requireNonNull(delegate);
        this.boltConnectionListener = Objects.requireNonNull(boltConnectionListener);
    }

    @Override
    public CompletionStage<BoltConnection> connect(BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, DatabaseName databaseName, Supplier<CompletionStage<AuthToken>> authTokenStageSupplier, AccessMode mode, Set<String> bookmarks, String impersonatedUser, BoltProtocolVersion minVersion, NotificationConfig notificationConfig, Consumer<DatabaseName> databaseNameConsumer, Map<String, Object> additionalParameters) {
        return this.delegate.connect(address, routingContext, boltAgent, userAgent, connectTimeoutMillis, securityPlan, databaseName, authTokenStageSupplier, mode, bookmarks, impersonatedUser, minVersion, notificationConfig, databaseNameConsumer, additionalParameters).thenApply(boltConnection -> {
            boltConnection = new ListeningBoltConnection((BoltConnection)boltConnection, this.boltConnectionListener);
            this.boltConnectionListener.onOpen((BoltConnection)boltConnection);
            return boltConnection;
        });
    }

    @Override
    public CompletionStage<Void> verifyConnectivity(BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken) {
        return this.delegate.verifyConnectivity(address, routingContext, boltAgent, userAgent, connectTimeoutMillis, securityPlan, authToken);
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb(BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken) {
        return this.delegate.supportsMultiDb(address, routingContext, boltAgent, userAgent, connectTimeoutMillis, securityPlan, authToken);
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth(BoltServerAddress address, RoutingContext routingContext, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken) {
        return this.delegate.supportsSessionAuth(address, routingContext, boltAgent, userAgent, connectTimeoutMillis, securityPlan, authToken);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.delegate.close();
    }
}

