/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.CodecException;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.AuthInfo;
import org.neo4j.driver.internal.bolt.api.AuthToken;
import org.neo4j.driver.internal.bolt.api.BoltConnection;
import org.neo4j.driver.internal.bolt.api.BoltConnectionState;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.NotificationConfig;
import org.neo4j.driver.internal.bolt.api.ResponseHandler;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.api.TelemetryApi;
import org.neo4j.driver.internal.bolt.api.TransactionType;
import org.neo4j.driver.internal.bolt.api.exception.BoltConnectionReadTimeoutException;
import org.neo4j.driver.internal.bolt.api.exception.BoltException;
import org.neo4j.driver.internal.bolt.api.exception.BoltFailureException;
import org.neo4j.driver.internal.bolt.api.exception.BoltProtocolException;
import org.neo4j.driver.internal.bolt.api.exception.BoltServiceUnavailableException;
import org.neo4j.driver.internal.bolt.api.exception.BoltUnsupportedFeatureException;
import org.neo4j.driver.internal.bolt.api.summary.BeginSummary;
import org.neo4j.driver.internal.bolt.api.summary.CommitSummary;
import org.neo4j.driver.internal.bolt.api.summary.DiscardSummary;
import org.neo4j.driver.internal.bolt.api.summary.LogoffSummary;
import org.neo4j.driver.internal.bolt.api.summary.LogonSummary;
import org.neo4j.driver.internal.bolt.api.summary.PullSummary;
import org.neo4j.driver.internal.bolt.api.summary.ResetSummary;
import org.neo4j.driver.internal.bolt.api.summary.RollbackSummary;
import org.neo4j.driver.internal.bolt.api.summary.RouteSummary;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.bolt.api.summary.TelemetrySummary;
import org.neo4j.driver.internal.bolt.api.values.Value;
import org.neo4j.driver.internal.bolt.api.values.ValueFactory;
import org.neo4j.driver.internal.bolt.basicimpl.MessageIgnoredException;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.BoltProtocol;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.MessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.PullMessageHandler;
import org.neo4j.driver.internal.bolt.basicimpl.spi.Connection;
import org.neo4j.driver.internal.bolt.basicimpl.util.FutureUtil;

public final class BoltConnectionImpl
implements BoltConnection {
    private final LoggingProvider logging;
    private final System.Logger log;
    private final BoltProtocol protocol;
    private final Connection connection;
    private final EventLoop eventLoop;
    private final String serverAgent;
    private final BoltServerAddress serverAddress;
    private final BoltProtocolVersion protocolVersion;
    private final boolean telemetrySupported;
    private final boolean serverSideRouting;
    private final AtomicReference<BoltConnectionState> stateRef = new AtomicReference<BoltConnectionState>(BoltConnectionState.OPEN);
    private final AtomicReference<CompletableFuture<AuthInfo>> authDataRef;
    private final Map<String, Value> routingContext;
    private final Queue<Function<ResponseHandler, CompletionStage<Void>>> messageWriters;
    private final Clock clock;
    private final ValueFactory valueFactory;

    public BoltConnectionImpl(BoltProtocol protocol, Connection connection, EventLoop eventLoop, AuthToken authToken, CompletableFuture<Long> latestAuthMillisFuture, RoutingContext routingContext, Clock clock, LoggingProvider logging, ValueFactory valueFactory) {
        this.protocol = Objects.requireNonNull(protocol);
        this.connection = Objects.requireNonNull(connection);
        this.eventLoop = Objects.requireNonNull(eventLoop);
        this.serverAgent = Objects.requireNonNull(connection.serverAgent());
        this.serverAddress = Objects.requireNonNull(connection.serverAddress());
        this.protocolVersion = Objects.requireNonNull(connection.protocol().version());
        this.telemetrySupported = connection.isTelemetryEnabled();
        this.serverSideRouting = connection.isSsrEnabled();
        this.authDataRef = new AtomicReference<CompletableFuture<AuthInfoImpl>>(CompletableFuture.completedFuture(new AuthInfoImpl(authToken, latestAuthMillisFuture.join())));
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.routingContext = routingContext.toMap().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> valueFactory.value(entry.getValue()), (a, b) -> b));
        this.messageWriters = new ArrayDeque<Function<ResponseHandler, CompletionStage<Void>>>();
        this.clock = Objects.requireNonNull(clock);
        this.logging = Objects.requireNonNull(logging);
        this.log = this.logging.getLog(this.getClass());
    }

    @Override
    public CompletionStage<BoltConnection> onLoop() {
        return this.executeInEventLoop(() -> {}).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> route(DatabaseName databaseName, String impersonatedUser, Set<String> bookmarks) {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.route(this.connection, this.routingContext, bookmarks, databaseName.databaseName().orElse(null), impersonatedUser, new MessageHandler<RouteSummary>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(RouteSummary summary) {
                handler.onRouteSummary(summary);
            }
        }, this.clock, this.logging, this.valueFactory))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> beginTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, String txType, NotificationConfig notificationConfig) {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.beginTransaction(this.connection, databaseName, accessMode, impersonatedUser, bookmarks, txTimeout, txMetadata, txType, notificationConfig, new MessageHandler<BeginSummary>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(BeginSummary summary) {
                handler.onBeginSummary(summary);
            }
        }, this.logging, this.valueFactory))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> runInAutoCommitTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.runAuto(this.connection, databaseName, accessMode, impersonatedUser, query, parameters, bookmarks, txTimeout, txMetadata, notificationConfig, new MessageHandler<RunSummary>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(RunSummary summary) {
                handler.onRunSummary(summary);
            }
        }, this.logging, this.valueFactory))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> run(String query, Map<String, Value> parameters) {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.run(this.connection, query, parameters, new MessageHandler<RunSummary>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(RunSummary summary) {
                handler.onRunSummary(summary);
            }
        }))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> pull(long qid, long request) {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.pull(this.connection, qid, request, new PullMessageHandler(){
            final /* synthetic */ ResponseHandler val$handler;
            {
                this.val$handler = responseHandler;
            }

            @Override
            public void onRecord(Value[] fields) {
                this.val$handler.onRecord(fields);
            }

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                this.val$handler.onError(throwable);
            }

            @Override
            public void onSummary(PullSummary success) {
                this.val$handler.onPullSummary(success);
            }
        }, this.valueFactory))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> discard(long qid, long number) {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.discard(this.connection, qid, number, new MessageHandler<DiscardSummary>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(DiscardSummary summary) {
                handler.onDiscardSummary(summary);
            }
        }, this.valueFactory))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> commit() {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.commitTransaction(this.connection, new MessageHandler<String>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(String bookmark) {
                handler.onCommitSummary(() -> Optional.ofNullable(bookmark));
            }
        }))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> rollback() {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.rollbackTransaction(this.connection, new MessageHandler<Void>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(Void summary) {
                handler.onRollbackSummary(RollbackSummaryImpl.INSTANCE);
            }
        }))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> reset() {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.reset(this.connection, new MessageHandler<Void>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(Void summary) {
                BoltConnectionImpl.this.stateRef.set(BoltConnectionState.OPEN);
                handler.onResetSummary(null);
            }
        }))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> logoff() {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.logoff(this.connection, new MessageHandler<Void>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(Void summary) {
                BoltConnectionImpl.this.authDataRef.set(new CompletableFuture());
                handler.onLogoffSummary(null);
            }
        }))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> logon(final AuthToken authToken) {
        return this.executeInEventLoop(() -> this.messageWriters.add(handler -> this.protocol.logon(this.connection, authToken.asMap(), this.clock, new MessageHandler<Void>(){

            @Override
            public void onError(Throwable throwable) {
                BoltConnectionImpl.this.updateState(throwable);
                handler.onError(throwable);
            }

            @Override
            public void onSummary(Void summary) {
                BoltConnectionImpl.this.authDataRef.get().complete(new AuthInfoImpl(authToken, BoltConnectionImpl.this.clock.millis()));
                handler.onLogonSummary(null);
            }
        }, this.valueFactory))).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> telemetry(TelemetryApi telemetryApi) {
        return this.executeInEventLoop(() -> {
            if (!this.telemetrySupported()) {
                throw new BoltUnsupportedFeatureException("telemetry not supported");
            }
            this.messageWriters.add(handler -> this.protocol.telemetry(this.connection, telemetryApi.getValue(), new MessageHandler<Void>(){

                @Override
                public void onError(Throwable throwable) {
                    BoltConnectionImpl.this.updateState(throwable);
                    handler.onError(throwable);
                }

                @Override
                public void onSummary(Void summary) {
                    handler.onTelemetrySummary(TelemetrySummaryImpl.INSTANCE);
                }
            }));
        }).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<BoltConnection> clear() {
        return this.executeInEventLoop(this.messageWriters::clear).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<Void> flush(ResponseHandler handler) {
        CompletableFuture flushFuture = new CompletableFuture();
        return this.executeInEventLoop(() -> {
            CompletionStage<Object> flushStage;
            if (this.connection.isOpen()) {
                flushStage = CompletableFuture.completedStage(null);
                ResponseHandleImpl responseHandler = new ResponseHandleImpl(handler, this.messageWriters.size());
                Iterator messageWriterIterator = this.messageWriters.iterator();
                while (messageWriterIterator.hasNext()) {
                    Function messageWriter = (Function)messageWriterIterator.next();
                    messageWriterIterator.remove();
                    flushStage = flushStage.thenCompose(ignored -> (CompletionStage)messageWriter.apply(responseHandler));
                }
            } else {
                throw new BoltServiceUnavailableException("Connection is closed");
            }
            flushStage.thenCompose(ignored -> this.connection.flush()).whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    if ((throwable = FutureUtil.completionExceptionCause(throwable)) instanceof CodecException && throwable.getCause() instanceof IOException) {
                        BoltServiceUnavailableException serviceError = new BoltServiceUnavailableException("Connection to the database failed", throwable.getCause());
                        this.forceClose("Connection has been closed due to encoding error").whenComplete((ignored1, ignored2) -> flushFuture.completeExceptionally(serviceError));
                    } else {
                        flushFuture.completeExceptionally((Throwable)throwable);
                    }
                } else {
                    flushFuture.complete(null);
                    this.log.log(System.Logger.Level.DEBUG, "flushed");
                }
            });
        }).thenCompose(ignored -> flushFuture);
    }

    @Override
    public CompletionStage<Void> forceClose(String reason) {
        if (this.stateRef.getAndSet(BoltConnectionState.CLOSED) != BoltConnectionState.CLOSED) {
            try {
                return this.connection.forceClose(reason).exceptionally(ignored -> null);
            }
            catch (Throwable throwable) {
                return CompletableFuture.completedStage(null);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<Void> close() {
        CompletionStage<Object> close;
        try {
            close = switch (this.stateRef.getAndSet(BoltConnectionState.CLOSED)) {
                default -> throw new IncompatibleClassChangeError();
                case BoltConnectionState.OPEN -> this.connection.close();
                case BoltConnectionState.ERROR -> this.connection.forceClose("Closing connection after error");
                case BoltConnectionState.FAILURE -> this.connection.forceClose("Closing connection after failure");
                case BoltConnectionState.CLOSED -> CompletableFuture.completedStage(null);
            };
        }
        catch (Throwable throwable) {
            close = CompletableFuture.completedStage(null);
        }
        return close.exceptionally(ignored -> null);
    }

    @Override
    public CompletionStage<Void> setReadTimeout(Duration duration) {
        return this.executeInEventLoop(() -> this.connection.setReadTimeout(duration));
    }

    @Override
    public BoltConnectionState state() {
        BoltConnectionState state = this.stateRef.get();
        if (state == BoltConnectionState.OPEN && !this.connection.isOpen()) {
            state = BoltConnectionState.CLOSED;
        }
        return state;
    }

    @Override
    public CompletionStage<AuthInfo> authInfo() {
        return this.authDataRef.get();
    }

    @Override
    public String serverAgent() {
        return this.serverAgent;
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.serverAddress;
    }

    @Override
    public BoltProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public boolean telemetrySupported() {
        return this.telemetrySupported;
    }

    @Override
    public boolean serverSideRoutingEnabled() {
        return this.serverSideRouting;
    }

    @Override
    public Optional<Duration> defaultReadTimeout() {
        return this.connection.defaultReadTimeoutMillis();
    }

    private CompletionStage<Void> executeInEventLoop(Runnable runnable) {
        CompletableFuture<Void> executeFuture = new CompletableFuture<Void>();
        Runnable stageCompletingRunnable = () -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                executeFuture.completeExceptionally(throwable);
            }
            executeFuture.complete(null);
        };
        if (this.eventLoop.inEventLoop()) {
            stageCompletingRunnable.run();
        } else {
            try {
                this.eventLoop.execute(stageCompletingRunnable);
            }
            catch (Throwable throwable) {
                executeFuture.completeExceptionally(throwable);
            }
        }
        return executeFuture;
    }

    private void updateState(Throwable throwable) {
        if (throwable instanceof BoltServiceUnavailableException) {
            if (throwable instanceof BoltConnectionReadTimeoutException) {
                this.stateRef.compareAndExchange(BoltConnectionState.OPEN, BoltConnectionState.ERROR);
            } else {
                this.stateRef.set(BoltConnectionState.CLOSED);
            }
        } else if (throwable instanceof BoltFailureException) {
            BoltFailureException boltFailureException = (BoltFailureException)throwable;
            if ("Neo.ClientError.Security.AuthorizationExpired".equals(boltFailureException.code())) {
                this.stateRef.compareAndExchange(BoltConnectionState.OPEN, BoltConnectionState.ERROR);
            } else {
                this.stateRef.compareAndExchange(BoltConnectionState.OPEN, BoltConnectionState.FAILURE);
            }
        } else if (throwable instanceof MessageIgnoredException) {
            this.stateRef.compareAndExchange(BoltConnectionState.OPEN, BoltConnectionState.FAILURE);
        } else {
            this.stateRef.updateAndGet(state -> switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case BoltConnectionState.OPEN, BoltConnectionState.ERROR, BoltConnectionState.FAILURE -> BoltConnectionState.ERROR;
                case BoltConnectionState.CLOSED -> BoltConnectionState.CLOSED;
            });
        }
    }

    private record AuthInfoImpl(AuthToken authToken, long authAckMillis) implements AuthInfo
    {
    }

    private static class ResponseHandleImpl
    implements ResponseHandler {
        private final ResponseHandler delegate;
        private final CompletableFuture<Void> summariesFuture = new CompletableFuture();
        private int expectedSummaries;

        private ResponseHandleImpl(ResponseHandler delegate, int expectedSummaries) {
            this.delegate = Objects.requireNonNull(delegate);
            this.expectedSummaries = expectedSummaries;
            this.summariesFuture.whenComplete((ignored1, ignored2) -> this.onComplete());
        }

        @Override
        public void onError(Throwable throwable) {
            if (!(throwable instanceof MessageIgnoredException)) {
                if (!this.summariesFuture.isDone()) {
                    this.runIgnoringError(() -> this.delegate.onError(throwable));
                    if (!(throwable instanceof BoltException) || throwable instanceof BoltServiceUnavailableException || throwable instanceof BoltProtocolException) {
                        this.expectedSummaries = 1;
                    }
                    this.handleSummary();
                }
            } else {
                this.onIgnored();
            }
        }

        @Override
        public void onBeginSummary(BeginSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onBeginSummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onRunSummary(RunSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onRunSummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onRecord(Value[] fields) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onRecord(fields));
            }
        }

        @Override
        public void onPullSummary(PullSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onPullSummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onDiscardSummary(DiscardSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onDiscardSummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onCommitSummary(CommitSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onCommitSummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onRollbackSummary(RollbackSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onRollbackSummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onResetSummary(ResetSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onResetSummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onRouteSummary(RouteSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onRouteSummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onLogoffSummary(LogoffSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onLogoffSummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onLogonSummary(LogonSummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onLogonSummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onTelemetrySummary(TelemetrySummary summary) {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(() -> this.delegate.onTelemetrySummary(summary));
                this.handleSummary();
            }
        }

        @Override
        public void onIgnored() {
            if (!this.summariesFuture.isDone()) {
                this.runIgnoringError(this.delegate::onIgnored);
                this.handleSummary();
            }
        }

        @Override
        public void onComplete() {
            this.runIgnoringError(this.delegate::onComplete);
        }

        private void handleSummary() {
            --this.expectedSummaries;
            if (this.expectedSummaries == 0) {
                this.summariesFuture.complete(null);
            }
        }

        private void runIgnoringError(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class RollbackSummaryImpl
    implements RollbackSummary {
        private static final RollbackSummary INSTANCE = new RollbackSummaryImpl();

        private RollbackSummaryImpl() {
        }
    }

    private static class TelemetrySummaryImpl
    implements TelemetrySummary {
        private static final TelemetrySummary INSTANCE = new TelemetrySummaryImpl();

        private TelemetrySummaryImpl() {
        }
    }
}

