/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.exceptions;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.GqlStatusErrorClassification;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.types.TypeSystem;
import org.neo4j.driver.util.Preview;

public class Neo4jException
extends RuntimeException {
    private static final long serialVersionUID = -80579062276712567L;
    private final String code;
    private final String gqlStatus;
    private final String statusDescription;
    private final Map<String, Value> diagnosticRecord;
    private final GqlStatusErrorClassification classification;
    private final String rawClassification;

    public Neo4jException(String message) {
        this("N/A", message);
    }

    public Neo4jException(String message, Throwable cause) {
        this("N/A", message, cause);
    }

    public Neo4jException(String code, String message) {
        this(code, message, null);
    }

    public Neo4jException(String code, String message, Throwable cause) {
        this(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), code, message, GqlStatusError.DIAGNOSTIC_RECORD, cause);
    }

    @Preview(name="GQL-error")
    public Neo4jException(String gqlStatus, String statusDescription, String code, String message, Map<String, Value> diagnosticRecord, Throwable cause) {
        super(message, cause);
        this.gqlStatus = Objects.requireNonNull(gqlStatus);
        this.statusDescription = Objects.requireNonNull(statusDescription);
        this.code = code;
        this.diagnosticRecord = Objects.requireNonNull(diagnosticRecord);
        Value rawClassification = diagnosticRecord.get("_classification");
        if (rawClassification != null && TypeSystem.getDefault().STRING().isTypeOf(rawClassification)) {
            this.rawClassification = rawClassification.asString();
            GqlStatusErrorClassification classification = null;
            try {
                classification = GqlStatusErrorClassification.valueOf(this.rawClassification);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.classification = classification;
        } else {
            this.rawClassification = null;
            this.classification = null;
        }
    }

    public String code() {
        return this.code;
    }

    @Preview(name="GQL-error")
    public String gqlStatus() {
        return this.gqlStatus;
    }

    @Preview(name="GQL-error")
    public String statusDescription() {
        return this.statusDescription;
    }

    @Preview(name="GQL-error")
    public Map<String, Value> diagnosticRecord() {
        return this.diagnosticRecord;
    }

    @Preview(name="GQL-error")
    public Optional<GqlStatusErrorClassification> classification() {
        return Optional.ofNullable(this.classification);
    }

    @Preview(name="GQL-error")
    public Optional<String> rawClassification() {
        return Optional.ofNullable(this.rawClassification);
    }

    @Preview(name="GQL-error")
    public Optional<Neo4jException> gqlCause() {
        return Neo4jException.findFirstGqlCause(this, Neo4jException.class);
    }

    private static <T extends Throwable> Optional<T> findFirstGqlCause(Throwable throwable, Class<T> targetCls) {
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return Optional.empty();
        }
        if (targetCls.isAssignableFrom(cause.getClass())) {
            return Optional.of((Throwable)targetCls.cast(cause));
        }
        return Optional.empty();
    }
}

