/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.net.URI;
import java.util.Objects;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.ClientCertificateManager;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.ValidatingClientCertificateManager;
import org.neo4j.driver.internal.security.StaticAuthTokenManager;
import org.neo4j.driver.internal.security.ValidatingAuthTokenManager;

public final class GraphDatabase {
    private GraphDatabase() {
    }

    public static Driver driver(String uri) {
        return GraphDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri) {
        return GraphDatabase.driver(uri, Config.defaultConfig());
    }

    public static Driver driver(URI uri, Config config) {
        return GraphDatabase.driver(uri, AuthTokens.none(), config);
    }

    public static Driver driver(String uri, Config config) {
        return GraphDatabase.driver(URI.create(uri), config);
    }

    public static Driver driver(String uri, AuthToken authToken) {
        return GraphDatabase.driver(uri, authToken, Config.defaultConfig());
    }

    public static Driver driver(URI uri, AuthToken authToken) {
        return GraphDatabase.driver(uri, authToken, Config.defaultConfig());
    }

    public static Driver driver(String uri, AuthToken authToken, Config config) {
        return GraphDatabase.driver(URI.create(uri), authToken, config);
    }

    public static Driver driver(URI uri, AuthToken authToken, Config config) {
        if (authToken == null) {
            authToken = AuthTokens.none();
        }
        return GraphDatabase.driver(uri, authToken, null, config, new DriverFactory());
    }

    public static Driver driver(URI uri, AuthTokenManager authTokenManager) {
        return GraphDatabase.driver(uri, authTokenManager, Config.defaultConfig());
    }

    public static Driver driver(String uri, AuthTokenManager authTokenManager) {
        return GraphDatabase.driver(URI.create(uri), authTokenManager);
    }

    public static Driver driver(URI uri, AuthTokenManager authTokenManager, Config config) {
        return GraphDatabase.driver(uri, authTokenManager, null, config, new DriverFactory());
    }

    public static Driver driver(String uri, AuthTokenManager authTokenManager, Config config) {
        return GraphDatabase.driver(URI.create(uri), authTokenManager, config);
    }

    public static Driver driver(String uri, ClientCertificateManager clientCertificateManager) {
        return GraphDatabase.driver(URI.create(uri), clientCertificateManager);
    }

    public static Driver driver(String uri, ClientCertificateManager clientCertificateManager, Config config) {
        return GraphDatabase.driver(URI.create(uri), clientCertificateManager, config);
    }

    public static Driver driver(String uri, AuthToken authToken, ClientCertificateManager clientCertificateManager) {
        return GraphDatabase.driver(URI.create(uri), authToken, clientCertificateManager);
    }

    public static Driver driver(String uri, AuthToken authToken, ClientCertificateManager clientCertificateManager, Config config) {
        return GraphDatabase.driver(URI.create(uri), authToken, clientCertificateManager, config);
    }

    public static Driver driver(String uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager) {
        return GraphDatabase.driver(URI.create(uri), authTokenManager, clientCertificateManager);
    }

    public static Driver driver(String uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager, Config config) {
        return GraphDatabase.driver(URI.create(uri), authTokenManager, clientCertificateManager, config);
    }

    public static Driver driver(URI uri, ClientCertificateManager clientCertificateManager) {
        return GraphDatabase.driver(uri, clientCertificateManager, Config.defaultConfig());
    }

    public static Driver driver(URI uri, ClientCertificateManager clientCertificateManager, Config config) {
        return GraphDatabase.driver(uri, AuthTokens.none(), clientCertificateManager, config);
    }

    public static Driver driver(URI uri, AuthToken authToken, ClientCertificateManager clientCertificateManager) {
        return GraphDatabase.driver(uri, authToken, clientCertificateManager, Config.defaultConfig());
    }

    public static Driver driver(URI uri, AuthToken authToken, ClientCertificateManager clientCertificateManager, Config config) {
        return GraphDatabase.driver(uri, authToken, clientCertificateManager, config, new DriverFactory());
    }

    public static Driver driver(URI uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager) {
        return GraphDatabase.driver(uri, authTokenManager, clientCertificateManager, Config.defaultConfig());
    }

    public static Driver driver(URI uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager, Config config) {
        return GraphDatabase.driver(uri, authTokenManager, clientCertificateManager, config, new DriverFactory());
    }

    private static Driver driver(URI uri, AuthToken authToken, ClientCertificateManager clientCertificateManager, Config config, DriverFactory driverFactory) {
        if (clientCertificateManager != null) {
            clientCertificateManager = new ValidatingClientCertificateManager(clientCertificateManager);
        }
        config = GraphDatabase.getOrDefault(config);
        return driverFactory.newInstance(uri, new StaticAuthTokenManager(authToken), clientCertificateManager, config);
    }

    private static Driver driver(URI uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager, Config config, DriverFactory driverFactory) {
        Objects.requireNonNull(authTokenManager, "authTokenManager must not be null");
        if (clientCertificateManager != null) {
            clientCertificateManager = new ValidatingClientCertificateManager(clientCertificateManager);
        }
        config = GraphDatabase.getOrDefault(config);
        return driverFactory.newInstance(uri, new ValidatingAuthTokenManager(authTokenManager, config.logging()), clientCertificateManager, config);
    }

    private static Config getOrDefault(Config config) {
        return config != null ? config : Config.defaultConfig();
    }
}

